package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class HostVolumeProperties(sourcePath: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.HostVolumeProperties = {
    import HostVolumeProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.HostVolumeProperties
      .builder()
      .optionallyWith(sourcePath.map(value => value: java.lang.String))(
        _.sourcePath
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.HostVolumeProperties.ReadOnly =
    zio.aws.ecs.model.HostVolumeProperties.wrap(buildAwsValue())
}
object HostVolumeProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.HostVolumeProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.HostVolumeProperties =
      zio.aws.ecs.model.HostVolumeProperties(sourcePath.map(value => value))
    def sourcePath: Option[String]
    def getSourcePath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourcePath", sourcePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.HostVolumeProperties
  ) extends zio.aws.ecs.model.HostVolumeProperties.ReadOnly {
    override val sourcePath: Option[String] =
      scala.Option(impl.sourcePath()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.HostVolumeProperties
  ): zio.aws.ecs.model.HostVolumeProperties.ReadOnly = new Wrapper(impl)
}
