package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class InstanceHealthCheckResult(
    `type`: Option[zio.aws.ecs.model.InstanceHealthCheckType] = None,
    status: Option[zio.aws.ecs.model.InstanceHealthCheckState] = None,
    lastUpdated: Option[Timestamp] = None,
    lastStatusChange: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult = {
    import InstanceHealthCheckResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        lastStatusChange.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStatusChange)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly =
    zio.aws.ecs.model.InstanceHealthCheckResult.wrap(buildAwsValue())
}
object InstanceHealthCheckResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.InstanceHealthCheckResult =
      zio.aws.ecs.model.InstanceHealthCheckResult(
        `type`.map(value => value),
        status.map(value => value),
        lastUpdated.map(value => value),
        lastStatusChange.map(value => value)
      )
    def `type`: Option[zio.aws.ecs.model.InstanceHealthCheckType]
    def status: Option[zio.aws.ecs.model.InstanceHealthCheckState]
    def lastUpdated: Option[Timestamp]
    def lastStatusChange: Option[Timestamp]
    def getType: ZIO[Any, AwsError, zio.aws.ecs.model.InstanceHealthCheckType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.InstanceHealthCheckState] =
      AwsError.unwrapOptionField("status", status)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getLastStatusChange: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult
  ) extends zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly {
    override val `type`: Option[zio.aws.ecs.model.InstanceHealthCheckType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.ecs.model.InstanceHealthCheckType.wrap(value))
    override val status: Option[zio.aws.ecs.model.InstanceHealthCheckState] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ecs.model.InstanceHealthCheckState.wrap(value))
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val lastStatusChange: Option[Timestamp] = scala
      .Option(impl.lastStatusChange())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult
  ): zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly = new Wrapper(impl)
}
