package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait IpcMode {
  def unwrap: software.amazon.awssdk.services.ecs.model.IpcMode
}
object IpcMode {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.IpcMode
  ): zio.aws.ecs.model.IpcMode = value match {
    case software.amazon.awssdk.services.ecs.model.IpcMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.IpcMode.HOST =>
      val r = host
      r
    case software.amazon.awssdk.services.ecs.model.IpcMode.TASK =>
      val r = task
      r
    case software.amazon.awssdk.services.ecs.model.IpcMode.NONE =>
      val r = none
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.IpcMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.IpcMode =
      software.amazon.awssdk.services.ecs.model.IpcMode.UNKNOWN_TO_SDK_VERSION
  }
  case object host extends zio.aws.ecs.model.IpcMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.IpcMode =
      software.amazon.awssdk.services.ecs.model.IpcMode.HOST
  }
  case object task extends zio.aws.ecs.model.IpcMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.IpcMode =
      software.amazon.awssdk.services.ecs.model.IpcMode.TASK
  }
  case object none extends zio.aws.ecs.model.IpcMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.IpcMode =
      software.amazon.awssdk.services.ecs.model.IpcMode.NONE
  }
}
