package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.{BoxedInteger, BoxedBoolean}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LinuxParameters(
    capabilities: Option[zio.aws.ecs.model.KernelCapabilities] = None,
    devices: Option[Iterable[zio.aws.ecs.model.Device]] = None,
    initProcessEnabled: Option[BoxedBoolean] = None,
    sharedMemorySize: Option[BoxedInteger] = None,
    tmpfs: Option[Iterable[zio.aws.ecs.model.Tmpfs]] = None,
    maxSwap: Option[BoxedInteger] = None,
    swappiness: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.LinuxParameters = {
    import LinuxParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.LinuxParameters
      .builder()
      .optionallyWith(capabilities.map(value => value.buildAwsValue()))(
        _.capabilities
      )
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        initProcessEnabled.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.initProcessEnabled)
      .optionallyWith(
        sharedMemorySize.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.sharedMemorySize)
      .optionallyWith(
        tmpfs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tmpfs)
      .optionallyWith(
        maxSwap.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.maxSwap)
      .optionallyWith(
        swappiness.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.swappiness)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.LinuxParameters.ReadOnly =
    zio.aws.ecs.model.LinuxParameters.wrap(buildAwsValue())
}
object LinuxParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.LinuxParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.LinuxParameters =
      zio.aws.ecs.model.LinuxParameters(
        capabilities.map(value => value.asEditable),
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        initProcessEnabled.map(value => value),
        sharedMemorySize.map(value => value),
        tmpfs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxSwap.map(value => value),
        swappiness.map(value => value)
      )
    def capabilities: Option[zio.aws.ecs.model.KernelCapabilities.ReadOnly]
    def devices: Option[List[zio.aws.ecs.model.Device.ReadOnly]]
    def initProcessEnabled: Option[BoxedBoolean]
    def sharedMemorySize: Option[BoxedInteger]
    def tmpfs: Option[List[zio.aws.ecs.model.Tmpfs.ReadOnly]]
    def maxSwap: Option[BoxedInteger]
    def swappiness: Option[BoxedInteger]
    def getCapabilities
        : ZIO[Any, AwsError, zio.aws.ecs.model.KernelCapabilities.ReadOnly] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getDevices
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Device.ReadOnly]] =
      AwsError.unwrapOptionField("devices", devices)
    def getInitProcessEnabled: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("initProcessEnabled", initProcessEnabled)
    def getSharedMemorySize: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("sharedMemorySize", sharedMemorySize)
    def getTmpfs: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tmpfs.ReadOnly]] =
      AwsError.unwrapOptionField("tmpfs", tmpfs)
    def getMaxSwap: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxSwap", maxSwap)
    def getSwappiness: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("swappiness", swappiness)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.LinuxParameters
  ) extends zio.aws.ecs.model.LinuxParameters.ReadOnly {
    override val capabilities
        : Option[zio.aws.ecs.model.KernelCapabilities.ReadOnly] = scala
      .Option(impl.capabilities())
      .map(value => zio.aws.ecs.model.KernelCapabilities.wrap(value))
    override val devices: Option[List[zio.aws.ecs.model.Device.ReadOnly]] =
      scala
        .Option(impl.devices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Device.wrap(item)
          }.toList
        )
    override val initProcessEnabled: Option[BoxedBoolean] = scala
      .Option(impl.initProcessEnabled())
      .map(value => zio.aws.ecs.model.primitives.BoxedBoolean(value))
    override val sharedMemorySize: Option[BoxedInteger] = scala
      .Option(impl.sharedMemorySize())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val tmpfs: Option[List[zio.aws.ecs.model.Tmpfs.ReadOnly]] = scala
      .Option(impl.tmpfs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tmpfs.wrap(item)
        }.toList
      )
    override val maxSwap: Option[BoxedInteger] = scala
      .Option(impl.maxSwap())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val swappiness: Option[BoxedInteger] = scala
      .Option(impl.swappiness())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.LinuxParameters
  ): zio.aws.ecs.model.LinuxParameters.ReadOnly = new Wrapper(impl)
}
