package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAttributesResponse(
    attributes: Option[Iterable[zio.aws.ecs.model.Attribute]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListAttributesResponse = {
    import ListAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListAttributesResponse.ReadOnly =
    zio.aws.ecs.model.ListAttributesResponse.wrap(buildAwsValue())
}
object ListAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListAttributesResponse =
      zio.aws.ecs.model.ListAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attributes: Option[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def nextToken: Option[String]
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListAttributesResponse
  ) extends zio.aws.ecs.model.ListAttributesResponse.ReadOnly {
    override val attributes
        : Option[List[zio.aws.ecs.model.Attribute.ReadOnly]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Attribute.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListAttributesResponse
  ): zio.aws.ecs.model.ListAttributesResponse.ReadOnly = new Wrapper(impl)
}
