package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListClustersRequest(
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListClustersRequest = {
    import ListClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListClustersRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListClustersRequest.ReadOnly =
    zio.aws.ecs.model.ListClustersRequest.wrap(buildAwsValue())
}
object ListClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListClustersRequest =
      zio.aws.ecs.model.ListClustersRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListClustersRequest
  ) extends zio.aws.ecs.model.ListClustersRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListClustersRequest
  ): zio.aws.ecs.model.ListClustersRequest.ReadOnly = new Wrapper(impl)
}
