package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ManagedAgentStateChange(
    containerName: String,
    managedAgentName: zio.aws.ecs.model.ManagedAgentName,
    status: String,
    reason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ManagedAgentStateChange = {
    import ManagedAgentStateChange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ManagedAgentStateChange
      .builder()
      .containerName(containerName: java.lang.String)
      .managedAgentName(managedAgentName.unwrap)
      .status(status: java.lang.String)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly =
    zio.aws.ecs.model.ManagedAgentStateChange.wrap(buildAwsValue())
}
object ManagedAgentStateChange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ManagedAgentStateChange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ManagedAgentStateChange =
      zio.aws.ecs.model.ManagedAgentStateChange(
        containerName,
        managedAgentName,
        status,
        reason.map(value => value)
      )
    def containerName: String
    def managedAgentName: zio.aws.ecs.model.ManagedAgentName
    def status: String
    def reason: Option[String]
    def getContainerName: ZIO[Any, Nothing, String] = ZIO.succeed(containerName)
    def getManagedAgentName
        : ZIO[Any, Nothing, zio.aws.ecs.model.ManagedAgentName] =
      ZIO.succeed(managedAgentName)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ManagedAgentStateChange
  ) extends zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly {
    override val containerName: String = impl.containerName(): String
    override val managedAgentName: zio.aws.ecs.model.ManagedAgentName =
      zio.aws.ecs.model.ManagedAgentName.wrap(impl.managedAgentName())
    override val status: String = impl.status(): String
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ManagedAgentStateChange
  ): zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly = new Wrapper(impl)
}
