package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait PidMode {
  def unwrap: software.amazon.awssdk.services.ecs.model.PidMode
}
object PidMode {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.PidMode
  ): zio.aws.ecs.model.PidMode = value match {
    case software.amazon.awssdk.services.ecs.model.PidMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.PidMode.HOST =>
      val r = host
      r
    case software.amazon.awssdk.services.ecs.model.PidMode.TASK =>
      val r = task
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.PidMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.PidMode =
      software.amazon.awssdk.services.ecs.model.PidMode.UNKNOWN_TO_SDK_VERSION
  }
  case object host extends zio.aws.ecs.model.PidMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.PidMode =
      software.amazon.awssdk.services.ecs.model.PidMode.HOST
  }
  case object task extends zio.aws.ecs.model.PidMode {
    override def unwrap: software.amazon.awssdk.services.ecs.model.PidMode =
      software.amazon.awssdk.services.ecs.model.PidMode.TASK
  }
}
