package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutAccountSettingDefaultRequest(
    name: zio.aws.ecs.model.SettingName,
    value: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest = {
    import PutAccountSettingDefaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest
      .builder()
      .name(name.unwrap)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PutAccountSettingDefaultRequest.ReadOnly =
    zio.aws.ecs.model.PutAccountSettingDefaultRequest.wrap(buildAwsValue())
}
object PutAccountSettingDefaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PutAccountSettingDefaultRequest =
      zio.aws.ecs.model.PutAccountSettingDefaultRequest(name, value)
    def name: zio.aws.ecs.model.SettingName
    def value: String
    def getName: ZIO[Any, Nothing, zio.aws.ecs.model.SettingName] =
      ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest
  ) extends zio.aws.ecs.model.PutAccountSettingDefaultRequest.ReadOnly {
    override val name: zio.aws.ecs.model.SettingName =
      zio.aws.ecs.model.SettingName.wrap(impl.name())
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest
  ): zio.aws.ecs.model.PutAccountSettingDefaultRequest.ReadOnly = new Wrapper(
    impl
  )
}
