package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RepositoryCredentials(credentialsParameter: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RepositoryCredentials = {
    import RepositoryCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RepositoryCredentials
      .builder()
      .credentialsParameter(credentialsParameter: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RepositoryCredentials.ReadOnly =
    zio.aws.ecs.model.RepositoryCredentials.wrap(buildAwsValue())
}
object RepositoryCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RepositoryCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RepositoryCredentials =
      zio.aws.ecs.model.RepositoryCredentials(credentialsParameter)
    def credentialsParameter: String
    def getCredentialsParameter: ZIO[Any, Nothing, String] =
      ZIO.succeed(credentialsParameter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RepositoryCredentials
  ) extends zio.aws.ecs.model.RepositoryCredentials.ReadOnly {
    override val credentialsParameter: String =
      impl.credentialsParameter(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RepositoryCredentials
  ): zio.aws.ecs.model.RepositoryCredentials.ReadOnly = new Wrapper(impl)
}
