package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.ecs.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ResourceType
  ): zio.aws.ecs.model.ResourceType = value match {
    case software.amazon.awssdk.services.ecs.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ResourceType.GPU =>
      val r = GPU
      r
    case software.amazon.awssdk.services.ecs.model.ResourceType.INFERENCE_ACCELERATOR =>
      val r = InferenceAccelerator
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ResourceType =
      software.amazon.awssdk.services.ecs.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object GPU extends zio.aws.ecs.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ResourceType =
      software.amazon.awssdk.services.ecs.model.ResourceType.GPU
  }
  case object InferenceAccelerator extends zio.aws.ecs.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ResourceType =
      software.amazon.awssdk.services.ecs.model.ResourceType.INFERENCE_ACCELERATOR
  }
}
