package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RunTaskRequest(
    capacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None,
    cluster: Option[String] = None,
    count: Option[BoxedInteger] = None,
    enableECSManagedTags: Option[Boolean] = None,
    enableExecuteCommand: Option[Boolean] = None,
    group: Option[String] = None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None,
    networkConfiguration: Option[zio.aws.ecs.model.NetworkConfiguration] = None,
    overrides: Option[zio.aws.ecs.model.TaskOverride] = None,
    placementConstraints: Option[
      Iterable[zio.aws.ecs.model.PlacementConstraint]
    ] = None,
    placementStrategy: Option[Iterable[zio.aws.ecs.model.PlacementStrategy]] =
      None,
    platformVersion: Option[String] = None,
    propagateTags: Option[zio.aws.ecs.model.PropagateTags] = None,
    referenceId: Option[String] = None,
    startedBy: Option[String] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None,
    taskDefinition: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RunTaskRequest = {
    import RunTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RunTaskRequest
      .builder()
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(count.map(value => BoxedInteger.unwrap(value): Integer))(
        _.count
      )
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(overrides.map(value => value.buildAwsValue()))(
        _.overrides
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(referenceId.map(value => value: java.lang.String))(
        _.referenceId
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .taskDefinition(taskDefinition: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RunTaskRequest.ReadOnly =
    zio.aws.ecs.model.RunTaskRequest.wrap(buildAwsValue())
}
object RunTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RunTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RunTaskRequest =
      zio.aws.ecs.model.RunTaskRequest(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cluster.map(value => value),
        count.map(value => value),
        enableECSManagedTags.map(value => value),
        enableExecuteCommand.map(value => value),
        group.map(value => value),
        launchType.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        overrides.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        propagateTags.map(value => value),
        referenceId.map(value => value),
        startedBy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskDefinition
      )
    def capacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def cluster: Option[String]
    def count: Option[BoxedInteger]
    def enableECSManagedTags: Option[Boolean]
    def enableExecuteCommand: Option[Boolean]
    def group: Option[String]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def overrides: Option[zio.aws.ecs.model.TaskOverride.ReadOnly]
    def placementConstraints
        : Option[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Option[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]]
    def platformVersion: Option[String]
    def propagateTags: Option[zio.aws.ecs.model.PropagateTags]
    def referenceId: Option[String]
    def startedBy: Option[String]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def taskDefinition: String
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getCount: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("count", count)
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getOverrides
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskOverride.ReadOnly] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getReferenceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTaskDefinition: ZIO[Any, Nothing, String] =
      ZIO.succeed(taskDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RunTaskRequest
  ) extends zio.aws.ecs.model.RunTaskRequest.ReadOnly {
    override val capacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val count: Option[BoxedInteger] = scala
      .Option(impl.count())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
    override val enableECSManagedTags: Option[Boolean] =
      scala.Option(impl.enableECSManagedTags()).map(value => value: Boolean)
    override val enableExecuteCommand: Option[Boolean] =
      scala.Option(impl.enableExecuteCommand()).map(value => value: Boolean)
    override val group: Option[String] =
      scala.Option(impl.group()).map(value => value: String)
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val overrides: Option[zio.aws.ecs.model.TaskOverride.ReadOnly] =
      scala
        .Option(impl.overrides())
        .map(value => zio.aws.ecs.model.TaskOverride.wrap(value))
    override val placementConstraints
        : Option[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]] = scala
      .Option(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PlacementConstraint.wrap(item)
        }.toList
      )
    override val placementStrategy
        : Option[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]] = scala
      .Option(impl.placementStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PlacementStrategy.wrap(item)
        }.toList
      )
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val propagateTags: Option[zio.aws.ecs.model.PropagateTags] = scala
      .Option(impl.propagateTags())
      .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val referenceId: Option[String] =
      scala.Option(impl.referenceId()).map(value => value: String)
    override val startedBy: Option[String] =
      scala.Option(impl.startedBy()).map(value => value: String)
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
    override val taskDefinition: String = impl.taskDefinition(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RunTaskRequest
  ): zio.aws.ecs.model.RunTaskRequest.ReadOnly = new Wrapper(impl)
}
