package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Scale(
    value: Option[Double] = None,
    unit: Option[zio.aws.ecs.model.ScaleUnit] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Scale = {
    import Scale.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Scale
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Scale.ReadOnly =
    zio.aws.ecs.model.Scale.wrap(buildAwsValue())
}
object Scale {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Scale] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Scale = zio.aws.ecs.model
      .Scale(value.map(value => value), unit.map(value => value))
    def value: Option[Double]
    def unit: Option[zio.aws.ecs.model.ScaleUnit]
    def getValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("value", value)
    def getUnit: ZIO[Any, AwsError, zio.aws.ecs.model.ScaleUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Scale
  ) extends zio.aws.ecs.model.Scale.ReadOnly {
    override val value: Option[Double] =
      scala.Option(impl.value()).map(value => value: Double)
    override val unit: Option[zio.aws.ecs.model.ScaleUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.ecs.model.ScaleUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Scale
  ): zio.aws.ecs.model.Scale.ReadOnly = new Wrapper(impl)
}
