package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Secret(name: String, valueFrom: String) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Secret = {
    import Secret.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Secret
      .builder()
      .name(name: java.lang.String)
      .valueFrom(valueFrom: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Secret.ReadOnly =
    zio.aws.ecs.model.Secret.wrap(buildAwsValue())
}
object Secret {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Secret] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Secret =
      zio.aws.ecs.model.Secret(name, valueFrom)
    def name: String
    def valueFrom: String
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValueFrom: ZIO[Any, Nothing, String] = ZIO.succeed(valueFrom)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Secret
  ) extends zio.aws.ecs.model.Secret.ReadOnly {
    override val name: String = impl.name(): String
    override val valueFrom: String = impl.valueFrom(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Secret
  ): zio.aws.ecs.model.Secret.ReadOnly = new Wrapper(impl)
}
