package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Setting(
    name: Option[zio.aws.ecs.model.SettingName] = None,
    value: Option[String] = None,
    principalArn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Setting = {
    import Setting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Setting
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Setting.ReadOnly =
    zio.aws.ecs.model.Setting.wrap(buildAwsValue())
}
object Setting {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Setting] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Setting = zio.aws.ecs.model.Setting(
      name.map(value => value),
      value.map(value => value),
      principalArn.map(value => value)
    )
    def name: Option[zio.aws.ecs.model.SettingName]
    def value: Option[String]
    def principalArn: Option[String]
    def getName: ZIO[Any, AwsError, zio.aws.ecs.model.SettingName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getPrincipalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Setting
  ) extends zio.aws.ecs.model.Setting.ReadOnly {
    override val name: Option[zio.aws.ecs.model.SettingName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ecs.model.SettingName.wrap(value))
    override val value: Option[String] =
      scala.Option(impl.value()).map(value => value: String)
    override val principalArn: Option[String] =
      scala.Option(impl.principalArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Setting
  ): zio.aws.ecs.model.Setting.ReadOnly = new Wrapper(impl)
}
