package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartTaskRequest(
    cluster: Option[String] = None,
    containerInstances: Iterable[String],
    enableECSManagedTags: Option[Boolean] = None,
    enableExecuteCommand: Option[Boolean] = None,
    group: Option[String] = None,
    networkConfiguration: Option[zio.aws.ecs.model.NetworkConfiguration] = None,
    overrides: Option[zio.aws.ecs.model.TaskOverride] = None,
    propagateTags: Option[zio.aws.ecs.model.PropagateTags] = None,
    referenceId: Option[String] = None,
    startedBy: Option[String] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None,
    taskDefinition: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.StartTaskRequest = {
    import StartTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.StartTaskRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .containerInstances(containerInstances.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(overrides.map(value => value.buildAwsValue()))(
        _.overrides
      )
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(referenceId.map(value => value: java.lang.String))(
        _.referenceId
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .taskDefinition(taskDefinition: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.StartTaskRequest.ReadOnly =
    zio.aws.ecs.model.StartTaskRequest.wrap(buildAwsValue())
}
object StartTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.StartTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.StartTaskRequest =
      zio.aws.ecs.model.StartTaskRequest(
        cluster.map(value => value),
        containerInstances,
        enableECSManagedTags.map(value => value),
        enableExecuteCommand.map(value => value),
        group.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        overrides.map(value => value.asEditable),
        propagateTags.map(value => value),
        referenceId.map(value => value),
        startedBy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskDefinition
      )
    def cluster: Option[String]
    def containerInstances: List[String]
    def enableECSManagedTags: Option[Boolean]
    def enableExecuteCommand: Option[Boolean]
    def group: Option[String]
    def networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def overrides: Option[zio.aws.ecs.model.TaskOverride.ReadOnly]
    def propagateTags: Option[zio.aws.ecs.model.PropagateTags]
    def referenceId: Option[String]
    def startedBy: Option[String]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def taskDefinition: String
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainerInstances: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(containerInstances)
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getOverrides
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskOverride.ReadOnly] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getReferenceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTaskDefinition: ZIO[Any, Nothing, String] =
      ZIO.succeed(taskDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.StartTaskRequest
  ) extends zio.aws.ecs.model.StartTaskRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val containerInstances: List[String] = impl
      .containerInstances()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val enableECSManagedTags: Option[Boolean] =
      scala.Option(impl.enableECSManagedTags()).map(value => value: Boolean)
    override val enableExecuteCommand: Option[Boolean] =
      scala.Option(impl.enableExecuteCommand()).map(value => value: Boolean)
    override val group: Option[String] =
      scala.Option(impl.group()).map(value => value: String)
    override val networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val overrides: Option[zio.aws.ecs.model.TaskOverride.ReadOnly] =
      scala
        .Option(impl.overrides())
        .map(value => zio.aws.ecs.model.TaskOverride.wrap(value))
    override val propagateTags: Option[zio.aws.ecs.model.PropagateTags] = scala
      .Option(impl.propagateTags())
      .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val referenceId: Option[String] =
      scala.Option(impl.referenceId()).map(value => value: String)
    override val startedBy: Option[String] =
      scala.Option(impl.startedBy()).map(value => value: String)
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
    override val taskDefinition: String = impl.taskDefinition(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.StartTaskRequest
  ): zio.aws.ecs.model.StartTaskRequest.ReadOnly = new Wrapper(impl)
}
