package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopTaskRequest(
    cluster: Option[String] = None,
    task: String,
    reason: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.StopTaskRequest = {
    import StopTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.StopTaskRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .task(task: java.lang.String)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.StopTaskRequest.ReadOnly =
    zio.aws.ecs.model.StopTaskRequest.wrap(buildAwsValue())
}
object StopTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.StopTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.StopTaskRequest =
      zio.aws.ecs.model.StopTaskRequest(
        cluster.map(value => value),
        task,
        reason.map(value => value)
      )
    def cluster: Option[String]
    def task: String
    def reason: Option[String]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTask: ZIO[Any, Nothing, String] = ZIO.succeed(task)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.StopTaskRequest
  ) extends zio.aws.ecs.model.StopTaskRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val task: String = impl.task(): String
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.StopTaskRequest
  ): zio.aws.ecs.model.StopTaskRequest.ReadOnly = new Wrapper(impl)
}
