package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Task(
    attachments: Option[Iterable[zio.aws.ecs.model.Attachment]] = None,
    attributes: Option[Iterable[zio.aws.ecs.model.Attribute]] = None,
    availabilityZone: Option[String] = None,
    capacityProviderName: Option[String] = None,
    clusterArn: Option[String] = None,
    connectivity: Option[zio.aws.ecs.model.Connectivity] = None,
    connectivityAt: Option[Timestamp] = None,
    containerInstanceArn: Option[String] = None,
    containers: Option[Iterable[zio.aws.ecs.model.Container]] = None,
    cpu: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    desiredStatus: Option[String] = None,
    enableExecuteCommand: Option[Boolean] = None,
    executionStoppedAt: Option[Timestamp] = None,
    group: Option[String] = None,
    healthStatus: Option[zio.aws.ecs.model.HealthStatus] = None,
    inferenceAccelerators: Option[
      Iterable[zio.aws.ecs.model.InferenceAccelerator]
    ] = None,
    lastStatus: Option[String] = None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None,
    memory: Option[String] = None,
    overrides: Option[zio.aws.ecs.model.TaskOverride] = None,
    platformVersion: Option[String] = None,
    platformFamily: Option[String] = None,
    pullStartedAt: Option[Timestamp] = None,
    pullStoppedAt: Option[Timestamp] = None,
    startedAt: Option[Timestamp] = None,
    startedBy: Option[String] = None,
    stopCode: Option[zio.aws.ecs.model.TaskStopCode] = None,
    stoppedAt: Option[Timestamp] = None,
    stoppedReason: Option[String] = None,
    stoppingAt: Option[Timestamp] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None,
    taskArn: Option[String] = None,
    taskDefinitionArn: Option[String] = None,
    version: Option[Long] = None,
    ephemeralStorage: Option[zio.aws.ecs.model.EphemeralStorage] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Task = {
    import Task.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Task
      .builder()
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        capacityProviderName.map(value => value: java.lang.String)
      )(_.capacityProviderName)
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(connectivity.map(value => value.unwrap))(_.connectivity)
      .optionallyWith(
        connectivityAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.connectivityAt)
      .optionallyWith(
        containerInstanceArn.map(value => value: java.lang.String)
      )(_.containerInstanceArn)
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(desiredStatus.map(value => value: java.lang.String))(
        _.desiredStatus
      )
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(
        executionStoppedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.executionStoppedAt)
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAccelerators)
      .optionallyWith(lastStatus.map(value => value: java.lang.String))(
        _.lastStatus
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(overrides.map(value => value.buildAwsValue()))(
        _.overrides
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(platformFamily.map(value => value: java.lang.String))(
        _.platformFamily
      )
      .optionallyWith(
        pullStartedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pullStartedAt)
      .optionallyWith(
        pullStoppedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pullStoppedAt)
      .optionallyWith(startedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(stopCode.map(value => value.unwrap))(_.stopCode)
      .optionallyWith(stoppedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.stoppedAt
      )
      .optionallyWith(stoppedReason.map(value => value: java.lang.String))(
        _.stoppedReason
      )
      .optionallyWith(
        stoppingAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.stoppingAt)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .optionallyWith(taskDefinitionArn.map(value => value: java.lang.String))(
        _.taskDefinitionArn
      )
      .optionallyWith(version.map(value => value: java.lang.Long))(_.version)
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Task.ReadOnly =
    zio.aws.ecs.model.Task.wrap(buildAwsValue())
}
object Task {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Task] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Task = zio.aws.ecs.model.Task(
      attachments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      attributes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      availabilityZone.map(value => value),
      capacityProviderName.map(value => value),
      clusterArn.map(value => value),
      connectivity.map(value => value),
      connectivityAt.map(value => value),
      containerInstanceArn.map(value => value),
      containers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      cpu.map(value => value),
      createdAt.map(value => value),
      desiredStatus.map(value => value),
      enableExecuteCommand.map(value => value),
      executionStoppedAt.map(value => value),
      group.map(value => value),
      healthStatus.map(value => value),
      inferenceAccelerators.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      lastStatus.map(value => value),
      launchType.map(value => value),
      memory.map(value => value),
      overrides.map(value => value.asEditable),
      platformVersion.map(value => value),
      platformFamily.map(value => value),
      pullStartedAt.map(value => value),
      pullStoppedAt.map(value => value),
      startedAt.map(value => value),
      startedBy.map(value => value),
      stopCode.map(value => value),
      stoppedAt.map(value => value),
      stoppedReason.map(value => value),
      stoppingAt.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      taskArn.map(value => value),
      taskDefinitionArn.map(value => value),
      version.map(value => value),
      ephemeralStorage.map(value => value.asEditable)
    )
    def attachments: Option[List[zio.aws.ecs.model.Attachment.ReadOnly]]
    def attributes: Option[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def availabilityZone: Option[String]
    def capacityProviderName: Option[String]
    def clusterArn: Option[String]
    def connectivity: Option[zio.aws.ecs.model.Connectivity]
    def connectivityAt: Option[Timestamp]
    def containerInstanceArn: Option[String]
    def containers: Option[List[zio.aws.ecs.model.Container.ReadOnly]]
    def cpu: Option[String]
    def createdAt: Option[Timestamp]
    def desiredStatus: Option[String]
    def enableExecuteCommand: Option[Boolean]
    def executionStoppedAt: Option[Timestamp]
    def group: Option[String]
    def healthStatus: Option[zio.aws.ecs.model.HealthStatus]
    def inferenceAccelerators
        : Option[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]]
    def lastStatus: Option[String]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def memory: Option[String]
    def overrides: Option[zio.aws.ecs.model.TaskOverride.ReadOnly]
    def platformVersion: Option[String]
    def platformFamily: Option[String]
    def pullStartedAt: Option[Timestamp]
    def pullStoppedAt: Option[Timestamp]
    def startedAt: Option[Timestamp]
    def startedBy: Option[String]
    def stopCode: Option[zio.aws.ecs.model.TaskStopCode]
    def stoppedAt: Option[Timestamp]
    def stoppedReason: Option[String]
    def stoppingAt: Option[Timestamp]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def taskArn: Option[String]
    def taskDefinitionArn: Option[String]
    def version: Option[Long]
    def ephemeralStorage: Option[zio.aws.ecs.model.EphemeralStorage.ReadOnly]
    def getAttachments
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      AwsError.unwrapOptionField("attachments", attachments)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getCapacityProviderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityProviderName", capacityProviderName)
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getConnectivity: ZIO[Any, AwsError, zio.aws.ecs.model.Connectivity] =
      AwsError.unwrapOptionField("connectivity", connectivity)
    def getConnectivityAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("connectivityAt", connectivityAt)
    def getContainerInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstanceArn", containerInstanceArn)
    def getContainers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Container.ReadOnly]] =
      AwsError.unwrapOptionField("containers", containers)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDesiredStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("desiredStatus", desiredStatus)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getExecutionStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executionStoppedAt", executionStoppedAt)
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
    def getHealthStatus: ZIO[Any, AwsError, zio.aws.ecs.model.HealthStatus] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.InferenceAccelerator.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inferenceAccelerators", inferenceAccelerators)
    def getLastStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastStatus", lastStatus)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getOverrides
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskOverride.ReadOnly] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformFamily", platformFamily)
    def getPullStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pullStartedAt", pullStartedAt)
    def getPullStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pullStoppedAt", pullStoppedAt)
    def getStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getStopCode: ZIO[Any, AwsError, zio.aws.ecs.model.TaskStopCode] =
      AwsError.unwrapOptionField("stopCode", stopCode)
    def getStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stoppedAt", stoppedAt)
    def getStoppedReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stoppedReason", stoppedReason)
    def getStoppingAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stoppingAt", stoppingAt)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getTaskDefinitionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinitionArn", taskDefinitionArn)
    def getVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("version", version)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Task
  ) extends zio.aws.ecs.model.Task.ReadOnly {
    override val attachments
        : Option[List[zio.aws.ecs.model.Attachment.ReadOnly]] = scala
      .Option(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Attachment.wrap(item)
        }.toList
      )
    override val attributes
        : Option[List[zio.aws.ecs.model.Attribute.ReadOnly]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Attribute.wrap(item)
        }.toList
      )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val capacityProviderName: Option[String] =
      scala.Option(impl.capacityProviderName()).map(value => value: String)
    override val clusterArn: Option[String] =
      scala.Option(impl.clusterArn()).map(value => value: String)
    override val connectivity: Option[zio.aws.ecs.model.Connectivity] = scala
      .Option(impl.connectivity())
      .map(value => zio.aws.ecs.model.Connectivity.wrap(value))
    override val connectivityAt: Option[Timestamp] = scala
      .Option(impl.connectivityAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val containerInstanceArn: Option[String] =
      scala.Option(impl.containerInstanceArn()).map(value => value: String)
    override val containers
        : Option[List[zio.aws.ecs.model.Container.ReadOnly]] = scala
      .Option(impl.containers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Container.wrap(item)
        }.toList
      )
    override val cpu: Option[String] =
      scala.Option(impl.cpu()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val desiredStatus: Option[String] =
      scala.Option(impl.desiredStatus()).map(value => value: String)
    override val enableExecuteCommand: Option[Boolean] =
      scala.Option(impl.enableExecuteCommand()).map(value => value: Boolean)
    override val executionStoppedAt: Option[Timestamp] = scala
      .Option(impl.executionStoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val group: Option[String] =
      scala.Option(impl.group()).map(value => value: String)
    override val healthStatus: Option[zio.aws.ecs.model.HealthStatus] = scala
      .Option(impl.healthStatus())
      .map(value => zio.aws.ecs.model.HealthStatus.wrap(value))
    override val inferenceAccelerators
        : Option[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]] = scala
      .Option(impl.inferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.InferenceAccelerator.wrap(item)
        }.toList
      )
    override val lastStatus: Option[String] =
      scala.Option(impl.lastStatus()).map(value => value: String)
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val memory: Option[String] =
      scala.Option(impl.memory()).map(value => value: String)
    override val overrides: Option[zio.aws.ecs.model.TaskOverride.ReadOnly] =
      scala
        .Option(impl.overrides())
        .map(value => zio.aws.ecs.model.TaskOverride.wrap(value))
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val platformFamily: Option[String] =
      scala.Option(impl.platformFamily()).map(value => value: String)
    override val pullStartedAt: Option[Timestamp] = scala
      .Option(impl.pullStartedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val pullStoppedAt: Option[Timestamp] = scala
      .Option(impl.pullStoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val startedAt: Option[Timestamp] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val startedBy: Option[String] =
      scala.Option(impl.startedBy()).map(value => value: String)
    override val stopCode: Option[zio.aws.ecs.model.TaskStopCode] = scala
      .Option(impl.stopCode())
      .map(value => zio.aws.ecs.model.TaskStopCode.wrap(value))
    override val stoppedAt: Option[Timestamp] = scala
      .Option(impl.stoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val stoppedReason: Option[String] =
      scala.Option(impl.stoppedReason()).map(value => value: String)
    override val stoppingAt: Option[Timestamp] = scala
      .Option(impl.stoppingAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
    override val taskArn: Option[String] =
      scala.Option(impl.taskArn()).map(value => value: String)
    override val taskDefinitionArn: Option[String] =
      scala.Option(impl.taskDefinitionArn()).map(value => value: String)
    override val version: Option[Long] =
      scala.Option(impl.version()).map(value => value: Long)
    override val ephemeralStorage
        : Option[zio.aws.ecs.model.EphemeralStorage.ReadOnly] = scala
      .Option(impl.ephemeralStorage())
      .map(value => zio.aws.ecs.model.EphemeralStorage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Task
  ): zio.aws.ecs.model.Task.ReadOnly = new Wrapper(impl)
}
