package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait TaskDefinitionStatus {
  def unwrap: software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus
}
object TaskDefinitionStatus {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus
  ): zio.aws.ecs.model.TaskDefinitionStatus = value match {
    case software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.TaskDefinitionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus =
      software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.ecs.model.TaskDefinitionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus =
      software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.ecs.model.TaskDefinitionStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus =
      software.amazon.awssdk.services.ecs.model.TaskDefinitionStatus.INACTIVE
  }
}
