package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateContainerAgentRequest(
    cluster: Option[String] = None,
    containerInstance: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest = {
    import UpdateContainerAgentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .containerInstance(containerInstance: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateContainerAgentRequest.ReadOnly =
    zio.aws.ecs.model.UpdateContainerAgentRequest.wrap(buildAwsValue())
}
object UpdateContainerAgentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateContainerAgentRequest =
      zio.aws.ecs.model.UpdateContainerAgentRequest(
        cluster.map(value => value),
        containerInstance
      )
    def cluster: Option[String]
    def containerInstance: String
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainerInstance: ZIO[Any, Nothing, String] =
      ZIO.succeed(containerInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest
  ) extends zio.aws.ecs.model.UpdateContainerAgentRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val containerInstance: String = impl.containerInstance(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest
  ): zio.aws.ecs.model.UpdateContainerAgentRequest.ReadOnly = new Wrapper(impl)
}
