package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateContainerInstancesStateResponse(
    containerInstances: Option[Iterable[zio.aws.ecs.model.ContainerInstance]] =
      None,
    failures: Option[Iterable[zio.aws.ecs.model.Failure]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateResponse = {
    import UpdateContainerInstancesStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateResponse
      .builder()
      .optionallyWith(
        containerInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerInstances)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.UpdateContainerInstancesStateResponse.ReadOnly =
    zio.aws.ecs.model.UpdateContainerInstancesStateResponse
      .wrap(buildAwsValue())
}
object UpdateContainerInstancesStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateContainerInstancesStateResponse =
      zio.aws.ecs.model.UpdateContainerInstancesStateResponse(
        containerInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerInstances
        : Option[List[zio.aws.ecs.model.ContainerInstance.ReadOnly]]
    def failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getContainerInstances: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("containerInstances", containerInstances)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateResponse
  ) extends zio.aws.ecs.model.UpdateContainerInstancesStateResponse.ReadOnly {
    override val containerInstances
        : Option[List[zio.aws.ecs.model.ContainerInstance.ReadOnly]] = scala
      .Option(impl.containerInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ContainerInstance.wrap(item)
        }.toList
      )
    override val failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      scala
        .Option(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateResponse
  ): zio.aws.ecs.model.UpdateContainerInstancesStateResponse.ReadOnly =
    new Wrapper(impl)
}
