package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateServicePrimaryTaskSetResponse(
    taskSet: Option[zio.aws.ecs.model.TaskSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetResponse = {
    import UpdateServicePrimaryTaskSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetResponse
      .builder()
      .optionallyWith(taskSet.map(value => value.buildAwsValue()))(_.taskSet)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.ReadOnly =
    zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.wrap(buildAwsValue())
}
object UpdateServicePrimaryTaskSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse =
      zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse(
        taskSet.map(value => value.asEditable)
      )
    def taskSet: Option[zio.aws.ecs.model.TaskSet.ReadOnly]
    def getTaskSet: ZIO[Any, AwsError, zio.aws.ecs.model.TaskSet.ReadOnly] =
      AwsError.unwrapOptionField("taskSet", taskSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetResponse
  ) extends zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.ReadOnly {
    override val taskSet: Option[zio.aws.ecs.model.TaskSet.ReadOnly] = scala
      .Option(impl.taskSet())
      .map(value => zio.aws.ecs.model.TaskSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetResponse
  ): zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.ReadOnly =
    new Wrapper(impl)
}
