package zio.aws.ecs
import zio.aws.ecs.model.RegisterContainerInstanceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.ecs.{
  EcsAsyncClientBuilder,
  EcsAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.ecs.model.{
  DeleteAccountSettingRequest,
  DeregisterContainerInstanceRequest,
  DeregisterTaskDefinitionRequest,
  ListTaskDefinitionFamiliesRequest,
  UpdateClusterRequest,
  DeleteTaskSetRequest,
  SubmitContainerStateChangeRequest,
  DeleteServiceRequest,
  RegisterContainerInstanceRequest,
  DescribeTasksRequest,
  PutAccountSettingRequest,
  DescribeContainerInstancesRequest,
  PutAccountSettingDefaultRequest,
  UpdateTaskSetRequest,
  CreateTaskSetRequest,
  UpdateContainerAgentRequest,
  StartTaskRequest,
  ListTagsForResourceRequest,
  SubmitAttachmentStateChangesRequest,
  ExecuteCommandRequest,
  CreateClusterRequest,
  DescribeTaskSetsRequest,
  RegisterTaskDefinitionRequest,
  UpdateContainerInstancesStateRequest,
  DescribeServicesRequest,
  CreateServiceRequest,
  DeleteAttributesRequest,
  DeleteClusterRequest,
  DescribeTaskDefinitionRequest,
  DeleteCapacityProviderRequest,
  ListTasksRequest,
  ListTaskDefinitionsRequest,
  StopTaskRequest,
  UntagResourceRequest,
  CreateCapacityProviderRequest,
  UpdateClusterSettingsRequest,
  DescribeCapacityProvidersRequest,
  SubmitTaskStateChangeRequest,
  ListContainerInstancesRequest,
  RunTaskRequest,
  ListServicesRequest,
  PutAttributesRequest,
  DiscoverPollEndpointRequest,
  ListAttributesRequest,
  PutClusterCapacityProvidersRequest,
  UpdateServiceRequest,
  ListClustersRequest,
  DescribeClustersRequest,
  UpdateServicePrimaryTaskSetRequest,
  TagResourceRequest,
  ListAccountSettingsRequest,
  UpdateCapacityProviderRequest
}
import software.amazon.awssdk.services.ecs.paginators.{
  ListTaskDefinitionsPublisher,
  ListServicesPublisher,
  ListTasksPublisher,
  ListAttributesPublisher,
  ListAccountSettingsPublisher,
  ListTaskDefinitionFamiliesPublisher,
  ListClustersPublisher,
  ListContainerInstancesPublisher
}
import zio.stream.ZStream
import software.amazon.awssdk.services.ecs.model.{
  DescribeTasksResponse,
  SubmitAttachmentStateChangesResponse,
  RegisterTaskDefinitionResponse,
  DeleteAttributesResponse,
  PutClusterCapacityProvidersResponse,
  RegisterContainerInstanceResponse,
  Attribute,
  ListContainerInstancesResponse,
  ListTasksResponse,
  UpdateServicePrimaryTaskSetResponse,
  DescribeTaskDefinitionResponse,
  DeregisterTaskDefinitionResponse,
  SubmitContainerStateChangeResponse,
  CreateTaskSetResponse,
  DescribeServicesResponse,
  UpdateContainerInstancesStateResponse,
  Setting,
  UpdateCapacityProviderResponse,
  UpdateClusterSettingsResponse,
  UpdateServiceResponse,
  DeleteTaskSetResponse,
  PutAccountSettingDefaultResponse,
  DeregisterContainerInstanceResponse,
  CreateServiceResponse,
  DeleteServiceResponse,
  DeleteAccountSettingResponse,
  ListTagsForResourceResponse,
  UpdateContainerAgentResponse,
  UntagResourceResponse,
  RunTaskResponse,
  CreateClusterResponse,
  CreateCapacityProviderResponse,
  DiscoverPollEndpointResponse,
  PutAttributesResponse,
  UpdateTaskSetResponse,
  StopTaskResponse,
  DescribeTaskSetsResponse,
  DescribeClustersResponse,
  DescribeCapacityProvidersResponse,
  ListAccountSettingsResponse,
  DeleteClusterResponse,
  ExecuteCommandResponse,
  DeleteCapacityProviderResponse,
  PutAccountSettingResponse,
  ListAttributesResponse,
  TagResourceResponse,
  SubmitTaskStateChangeResponse,
  ListTaskDefinitionsResponse,
  ListTaskDefinitionFamiliesResponse,
  StartTaskResponse,
  ListClustersResponse,
  UpdateClusterResponse,
  DescribeContainerInstancesResponse,
  ListServicesResponse
}
import scala.jdk.CollectionConverters.*
trait Ecs extends AspectSupport[Ecs] {
  val api: EcsAsyncClient
  def registerTaskDefinition(
      request: RegisterTaskDefinitionRequest
  ): IO[AwsError, zio.aws.ecs.model.RegisterTaskDefinitionResponse.ReadOnly]
  def submitContainerStateChange(
      request: SubmitContainerStateChangeRequest
  ): IO[AwsError, zio.aws.ecs.model.SubmitContainerStateChangeResponse.ReadOnly]
  def submitAttachmentStateChanges(
      request: SubmitAttachmentStateChangesRequest
  ): IO[
    AwsError,
    zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.ReadOnly
  ]
  def describeTaskDefinition(
      request: DescribeTaskDefinitionRequest
  ): IO[AwsError, zio.aws.ecs.model.DescribeTaskDefinitionResponse.ReadOnly]
  def describeClusters(
      request: DescribeClustersRequest
  ): IO[AwsError, zio.aws.ecs.model.DescribeClustersResponse.ReadOnly]
  def putAccountSettingDefault(
      request: PutAccountSettingDefaultRequest
  ): IO[AwsError, zio.aws.ecs.model.PutAccountSettingDefaultResponse.ReadOnly]
  def putAttributes(
      request: PutAttributesRequest
  ): IO[AwsError, zio.aws.ecs.model.PutAttributesResponse.ReadOnly]
  def listTaskDefinitionFamilies(
      request: ListTaskDefinitionFamiliesRequest
  ): ZStream[Any, AwsError, String]
  def listTaskDefinitionFamiliesPaginated(
      request: ListTaskDefinitionFamiliesRequest
  ): IO[AwsError, zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly]
  def createService(
      request: CreateServiceRequest
  ): IO[AwsError, zio.aws.ecs.model.CreateServiceResponse.ReadOnly]
  def createTaskSet(
      request: CreateTaskSetRequest
  ): IO[AwsError, zio.aws.ecs.model.CreateTaskSetResponse.ReadOnly]
  def startTask(
      request: StartTaskRequest
  ): IO[AwsError, zio.aws.ecs.model.StartTaskResponse.ReadOnly]
  def deleteTaskSet(
      request: DeleteTaskSetRequest
  ): IO[AwsError, zio.aws.ecs.model.DeleteTaskSetResponse.ReadOnly]
  def deregisterContainerInstance(
      request: DeregisterContainerInstanceRequest
  ): IO[
    AwsError,
    zio.aws.ecs.model.DeregisterContainerInstanceResponse.ReadOnly
  ]
  def discoverPollEndpoint(
      request: DiscoverPollEndpointRequest
  ): IO[AwsError, zio.aws.ecs.model.DiscoverPollEndpointResponse.ReadOnly]
  def registerContainerInstance(
      request: RegisterContainerInstanceRequest
  ): IO[AwsError, ReadOnly]
  def describeContainerInstances(
      request: DescribeContainerInstancesRequest
  ): IO[AwsError, zio.aws.ecs.model.DescribeContainerInstancesResponse.ReadOnly]
  def deleteAttributes(
      request: DeleteAttributesRequest
  ): IO[AwsError, zio.aws.ecs.model.DeleteAttributesResponse.ReadOnly]
  def deleteService(
      request: DeleteServiceRequest
  ): IO[AwsError, zio.aws.ecs.model.DeleteServiceResponse.ReadOnly]
  def putClusterCapacityProviders(
      request: PutClusterCapacityProvidersRequest
  ): IO[
    AwsError,
    zio.aws.ecs.model.PutClusterCapacityProvidersResponse.ReadOnly
  ]
  def listServices(request: ListServicesRequest): ZStream[Any, AwsError, String]
  def listServicesPaginated(
      request: ListServicesRequest
  ): IO[AwsError, zio.aws.ecs.model.ListServicesResponse.ReadOnly]
  def createCluster(
      request: CreateClusterRequest
  ): IO[AwsError, zio.aws.ecs.model.CreateClusterResponse.ReadOnly]
  def deleteCluster(
      request: DeleteClusterRequest
  ): IO[AwsError, zio.aws.ecs.model.DeleteClusterResponse.ReadOnly]
  def describeTaskSets(
      request: DescribeTaskSetsRequest
  ): IO[AwsError, zio.aws.ecs.model.DescribeTaskSetsResponse.ReadOnly]
  def updateCluster(
      request: UpdateClusterRequest
  ): IO[AwsError, zio.aws.ecs.model.UpdateClusterResponse.ReadOnly]
  def executeCommand(
      request: ExecuteCommandRequest
  ): IO[AwsError, zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly]
  def runTask(
      request: RunTaskRequest
  ): IO[AwsError, zio.aws.ecs.model.RunTaskResponse.ReadOnly]
  def listContainerInstances(
      request: ListContainerInstancesRequest
  ): ZStream[Any, AwsError, String]
  def listContainerInstancesPaginated(
      request: ListContainerInstancesRequest
  ): IO[AwsError, zio.aws.ecs.model.ListContainerInstancesResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.ecs.model.UntagResourceResponse.ReadOnly]
  def submitTaskStateChange(
      request: SubmitTaskStateChangeRequest
  ): IO[AwsError, zio.aws.ecs.model.SubmitTaskStateChangeResponse.ReadOnly]
  def updateServicePrimaryTaskSet(
      request: UpdateServicePrimaryTaskSetRequest
  ): IO[
    AwsError,
    zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.ReadOnly
  ]
  def describeTasks(
      request: DescribeTasksRequest
  ): IO[AwsError, zio.aws.ecs.model.DescribeTasksResponse.ReadOnly]
  def describeCapacityProviders(
      request: DescribeCapacityProvidersRequest
  ): IO[AwsError, zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly]
  def listTaskDefinitions(
      request: ListTaskDefinitionsRequest
  ): ZStream[Any, AwsError, String]
  def listTaskDefinitionsPaginated(
      request: ListTaskDefinitionsRequest
  ): IO[AwsError, zio.aws.ecs.model.ListTaskDefinitionsResponse.ReadOnly]
  def deleteCapacityProvider(
      request: DeleteCapacityProviderRequest
  ): IO[AwsError, zio.aws.ecs.model.DeleteCapacityProviderResponse.ReadOnly]
  def deregisterTaskDefinition(
      request: DeregisterTaskDefinitionRequest
  ): IO[AwsError, zio.aws.ecs.model.DeregisterTaskDefinitionResponse.ReadOnly]
  def updateClusterSettings(
      request: UpdateClusterSettingsRequest
  ): IO[AwsError, zio.aws.ecs.model.UpdateClusterSettingsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.ecs.model.ListTagsForResourceResponse.ReadOnly]
  def updateContainerInstancesState(
      request: UpdateContainerInstancesStateRequest
  ): IO[
    AwsError,
    zio.aws.ecs.model.UpdateContainerInstancesStateResponse.ReadOnly
  ]
  def listClusters(request: ListClustersRequest): ZStream[Any, AwsError, String]
  def listClustersPaginated(
      request: ListClustersRequest
  ): IO[AwsError, zio.aws.ecs.model.ListClustersResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.ecs.model.TagResourceResponse.ReadOnly]
  def updateTaskSet(
      request: UpdateTaskSetRequest
  ): IO[AwsError, zio.aws.ecs.model.UpdateTaskSetResponse.ReadOnly]
  def listAccountSettings(
      request: ListAccountSettingsRequest
  ): ZStream[Any, AwsError, zio.aws.ecs.model.Setting.ReadOnly]
  def listAccountSettingsPaginated(
      request: ListAccountSettingsRequest
  ): IO[AwsError, zio.aws.ecs.model.ListAccountSettingsResponse.ReadOnly]
  def listTasks(request: ListTasksRequest): ZStream[Any, AwsError, String]
  def listTasksPaginated(
      request: ListTasksRequest
  ): IO[AwsError, zio.aws.ecs.model.ListTasksResponse.ReadOnly]
  def deleteAccountSetting(
      request: DeleteAccountSettingRequest
  ): IO[AwsError, zio.aws.ecs.model.DeleteAccountSettingResponse.ReadOnly]
  def updateContainerAgent(
      request: UpdateContainerAgentRequest
  ): IO[AwsError, zio.aws.ecs.model.UpdateContainerAgentResponse.ReadOnly]
  def updateService(
      request: UpdateServiceRequest
  ): IO[AwsError, zio.aws.ecs.model.UpdateServiceResponse.ReadOnly]
  def stopTask(
      request: StopTaskRequest
  ): IO[AwsError, zio.aws.ecs.model.StopTaskResponse.ReadOnly]
  def updateCapacityProvider(
      request: UpdateCapacityProviderRequest
  ): IO[AwsError, zio.aws.ecs.model.UpdateCapacityProviderResponse.ReadOnly]
  def putAccountSetting(
      request: PutAccountSettingRequest
  ): IO[AwsError, zio.aws.ecs.model.PutAccountSettingResponse.ReadOnly]
  def createCapacityProvider(
      request: CreateCapacityProviderRequest
  ): IO[AwsError, zio.aws.ecs.model.CreateCapacityProviderResponse.ReadOnly]
  def listAttributes(
      request: ListAttributesRequest
  ): ZStream[Any, AwsError, zio.aws.ecs.model.Attribute.ReadOnly]
  def listAttributesPaginated(
      request: ListAttributesRequest
  ): IO[AwsError, zio.aws.ecs.model.ListAttributesResponse.ReadOnly]
  def describeServices(
      request: DescribeServicesRequest
  ): IO[AwsError, zio.aws.ecs.model.DescribeServicesResponse.ReadOnly]
}
object Ecs {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Ecs] = customized(identity)
  def customized(
      customization: EcsAsyncClientBuilder => EcsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Ecs] = managed(
    customization
  ).toLayer
  def managed(
      customization: EcsAsyncClientBuilder => EcsAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Ecs] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = EcsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[EcsAsyncClient, EcsAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[EcsAsyncClient, EcsAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new EcsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class EcsImpl[R](
      override val api: EcsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Ecs
      with AwsServiceBase[R] {
    override val serviceName: String = "Ecs"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): EcsImpl[R1] = new EcsImpl(api, newAspect, r)
    def registerTaskDefinition(
        request: RegisterTaskDefinitionRequest
    ): IO[AwsError, zio.aws.ecs.model.RegisterTaskDefinitionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest,
        RegisterTaskDefinitionResponse
      ]("registerTaskDefinition", api.registerTaskDefinition)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.RegisterTaskDefinitionResponse.wrap)
        .provideEnvironment(r)
    def submitContainerStateChange(
        request: SubmitContainerStateChangeRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.SubmitContainerStateChangeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest,
      SubmitContainerStateChangeResponse
    ]("submitContainerStateChange", api.submitContainerStateChange)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.SubmitContainerStateChangeResponse.wrap)
      .provideEnvironment(r)
    def submitAttachmentStateChanges(
        request: SubmitAttachmentStateChangesRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.SubmitAttachmentStateChangesRequest,
      SubmitAttachmentStateChangesResponse
    ]("submitAttachmentStateChanges", api.submitAttachmentStateChanges)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.wrap)
      .provideEnvironment(r)
    def describeTaskDefinition(
        request: DescribeTaskDefinitionRequest
    ): IO[AwsError, zio.aws.ecs.model.DescribeTaskDefinitionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DescribeTaskDefinitionRequest,
        DescribeTaskDefinitionResponse
      ]("describeTaskDefinition", api.describeTaskDefinition)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.DescribeTaskDefinitionResponse.wrap)
        .provideEnvironment(r)
    def describeClusters(
        request: DescribeClustersRequest
    ): IO[AwsError, zio.aws.ecs.model.DescribeClustersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DescribeClustersRequest,
        DescribeClustersResponse
      ]("describeClusters", api.describeClusters)(request.buildAwsValue())
        .map(zio.aws.ecs.model.DescribeClustersResponse.wrap)
        .provideEnvironment(r)
    def putAccountSettingDefault(request: PutAccountSettingDefaultRequest): IO[
      AwsError,
      zio.aws.ecs.model.PutAccountSettingDefaultResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultRequest,
      PutAccountSettingDefaultResponse
    ]("putAccountSettingDefault", api.putAccountSettingDefault)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.PutAccountSettingDefaultResponse.wrap)
      .provideEnvironment(r)
    def putAttributes(
        request: PutAttributesRequest
    ): IO[AwsError, zio.aws.ecs.model.PutAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.PutAttributesRequest,
        PutAttributesResponse
      ]("putAttributes", api.putAttributes)(request.buildAwsValue())
        .map(zio.aws.ecs.model.PutAttributesResponse.wrap)
        .provideEnvironment(r)
    def listTaskDefinitionFamilies(
        request: ListTaskDefinitionFamiliesRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest,
      java.lang.String,
      ListTaskDefinitionFamiliesPublisher
    ](
      "listTaskDefinitionFamilies",
      api.listTaskDefinitionFamiliesPaginator,
      _.families()
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listTaskDefinitionFamiliesPaginated(
        request: ListTaskDefinitionFamiliesRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest,
      ListTaskDefinitionFamiliesResponse
    ]("listTaskDefinitionFamilies", api.listTaskDefinitionFamilies)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.wrap)
      .provideEnvironment(r)
    def createService(
        request: CreateServiceRequest
    ): IO[AwsError, zio.aws.ecs.model.CreateServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.CreateServiceRequest,
        CreateServiceResponse
      ]("createService", api.createService)(request.buildAwsValue())
        .map(zio.aws.ecs.model.CreateServiceResponse.wrap)
        .provideEnvironment(r)
    def createTaskSet(
        request: CreateTaskSetRequest
    ): IO[AwsError, zio.aws.ecs.model.CreateTaskSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.CreateTaskSetRequest,
        CreateTaskSetResponse
      ]("createTaskSet", api.createTaskSet)(request.buildAwsValue())
        .map(zio.aws.ecs.model.CreateTaskSetResponse.wrap)
        .provideEnvironment(r)
    def startTask(
        request: StartTaskRequest
    ): IO[AwsError, zio.aws.ecs.model.StartTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.StartTaskRequest,
        StartTaskResponse
      ]("startTask", api.startTask)(request.buildAwsValue())
        .map(zio.aws.ecs.model.StartTaskResponse.wrap)
        .provideEnvironment(r)
    def deleteTaskSet(
        request: DeleteTaskSetRequest
    ): IO[AwsError, zio.aws.ecs.model.DeleteTaskSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest,
        DeleteTaskSetResponse
      ]("deleteTaskSet", api.deleteTaskSet)(request.buildAwsValue())
        .map(zio.aws.ecs.model.DeleteTaskSetResponse.wrap)
        .provideEnvironment(r)
    def deregisterContainerInstance(
        request: DeregisterContainerInstanceRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.DeregisterContainerInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest,
      DeregisterContainerInstanceResponse
    ]("deregisterContainerInstance", api.deregisterContainerInstance)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.DeregisterContainerInstanceResponse.wrap)
      .provideEnvironment(r)
    def discoverPollEndpoint(
        request: DiscoverPollEndpointRequest
    ): IO[AwsError, zio.aws.ecs.model.DiscoverPollEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointRequest,
        DiscoverPollEndpointResponse
      ]("discoverPollEndpoint", api.discoverPollEndpoint)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.DiscoverPollEndpointResponse.wrap)
        .provideEnvironment(r)
    def registerContainerInstance(
        request: RegisterContainerInstanceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest,
      RegisterContainerInstanceResponse
    ]("registerContainerInstance", api.registerContainerInstance)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.RegisterContainerInstanceResponse.wrap)
      .provideEnvironment(r)
    def describeContainerInstances(
        request: DescribeContainerInstancesRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.DescribeContainerInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest,
      DescribeContainerInstancesResponse
    ]("describeContainerInstances", api.describeContainerInstances)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.DescribeContainerInstancesResponse.wrap)
      .provideEnvironment(r)
    def deleteAttributes(
        request: DeleteAttributesRequest
    ): IO[AwsError, zio.aws.ecs.model.DeleteAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DeleteAttributesRequest,
        DeleteAttributesResponse
      ]("deleteAttributes", api.deleteAttributes)(request.buildAwsValue())
        .map(zio.aws.ecs.model.DeleteAttributesResponse.wrap)
        .provideEnvironment(r)
    def deleteService(
        request: DeleteServiceRequest
    ): IO[AwsError, zio.aws.ecs.model.DeleteServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DeleteServiceRequest,
        DeleteServiceResponse
      ]("deleteService", api.deleteService)(request.buildAwsValue())
        .map(zio.aws.ecs.model.DeleteServiceResponse.wrap)
        .provideEnvironment(r)
    def putClusterCapacityProviders(
        request: PutClusterCapacityProvidersRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.PutClusterCapacityProvidersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.PutClusterCapacityProvidersRequest,
      PutClusterCapacityProvidersResponse
    ]("putClusterCapacityProviders", api.putClusterCapacityProviders)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.PutClusterCapacityProvidersResponse.wrap)
      .provideEnvironment(r)
    def listServices(
        request: ListServicesRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.ecs.model.ListServicesRequest,
      java.lang.String,
      ListServicesPublisher
    ]("listServices", api.listServicesPaginator, _.serviceArns())(
      request.buildAwsValue()
    ).map(item => item: String).provideEnvironment(r)
    def listServicesPaginated(
        request: ListServicesRequest
    ): IO[AwsError, zio.aws.ecs.model.ListServicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ListServicesRequest,
        ListServicesResponse
      ]("listServices", api.listServices)(request.buildAwsValue())
        .map(zio.aws.ecs.model.ListServicesResponse.wrap)
        .provideEnvironment(r)
    def createCluster(
        request: CreateClusterRequest
    ): IO[AwsError, zio.aws.ecs.model.CreateClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.CreateClusterRequest,
        CreateClusterResponse
      ]("createCluster", api.createCluster)(request.buildAwsValue())
        .map(zio.aws.ecs.model.CreateClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteCluster(
        request: DeleteClusterRequest
    ): IO[AwsError, zio.aws.ecs.model.DeleteClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DeleteClusterRequest,
        DeleteClusterResponse
      ]("deleteCluster", api.deleteCluster)(request.buildAwsValue())
        .map(zio.aws.ecs.model.DeleteClusterResponse.wrap)
        .provideEnvironment(r)
    def describeTaskSets(
        request: DescribeTaskSetsRequest
    ): IO[AwsError, zio.aws.ecs.model.DescribeTaskSetsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DescribeTaskSetsRequest,
        DescribeTaskSetsResponse
      ]("describeTaskSets", api.describeTaskSets)(request.buildAwsValue())
        .map(zio.aws.ecs.model.DescribeTaskSetsResponse.wrap)
        .provideEnvironment(r)
    def updateCluster(
        request: UpdateClusterRequest
    ): IO[AwsError, zio.aws.ecs.model.UpdateClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.UpdateClusterRequest,
        UpdateClusterResponse
      ]("updateCluster", api.updateCluster)(request.buildAwsValue())
        .map(zio.aws.ecs.model.UpdateClusterResponse.wrap)
        .provideEnvironment(r)
    def executeCommand(
        request: ExecuteCommandRequest
    ): IO[AwsError, zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ExecuteCommandRequest,
        ExecuteCommandResponse
      ]("executeCommand", api.executeCommand)(request.buildAwsValue())
        .map(zio.aws.ecs.model.ExecuteCommandResponse.wrap)
        .provideEnvironment(r)
    def runTask(
        request: RunTaskRequest
    ): IO[AwsError, zio.aws.ecs.model.RunTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.RunTaskRequest,
        RunTaskResponse
      ]("runTask", api.runTask)(request.buildAwsValue())
        .map(zio.aws.ecs.model.RunTaskResponse.wrap)
        .provideEnvironment(r)
    def listContainerInstances(
        request: ListContainerInstancesRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest,
      java.lang.String,
      ListContainerInstancesPublisher
    ](
      "listContainerInstances",
      api.listContainerInstancesPaginator,
      _.containerInstanceArns()
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listContainerInstancesPaginated(
        request: ListContainerInstancesRequest
    ): IO[AwsError, zio.aws.ecs.model.ListContainerInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ListContainerInstancesRequest,
        ListContainerInstancesResponse
      ]("listContainerInstances", api.listContainerInstances)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.ListContainerInstancesResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.ecs.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.ecs.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def submitTaskStateChange(
        request: SubmitTaskStateChangeRequest
    ): IO[AwsError, zio.aws.ecs.model.SubmitTaskStateChangeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest,
        SubmitTaskStateChangeResponse
      ]("submitTaskStateChange", api.submitTaskStateChange)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.SubmitTaskStateChangeResponse.wrap)
        .provideEnvironment(r)
    def updateServicePrimaryTaskSet(
        request: UpdateServicePrimaryTaskSetRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest,
      UpdateServicePrimaryTaskSetResponse
    ]("updateServicePrimaryTaskSet", api.updateServicePrimaryTaskSet)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.wrap)
      .provideEnvironment(r)
    def describeTasks(
        request: DescribeTasksRequest
    ): IO[AwsError, zio.aws.ecs.model.DescribeTasksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DescribeTasksRequest,
        DescribeTasksResponse
      ]("describeTasks", api.describeTasks)(request.buildAwsValue())
        .map(zio.aws.ecs.model.DescribeTasksResponse.wrap)
        .provideEnvironment(r)
    def describeCapacityProviders(
        request: DescribeCapacityProvidersRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.DescribeCapacityProvidersRequest,
      DescribeCapacityProvidersResponse
    ]("describeCapacityProviders", api.describeCapacityProviders)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.DescribeCapacityProvidersResponse.wrap)
      .provideEnvironment(r)
    def listTaskDefinitions(
        request: ListTaskDefinitionsRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest,
      java.lang.String,
      ListTaskDefinitionsPublisher
    ](
      "listTaskDefinitions",
      api.listTaskDefinitionsPaginator,
      _.taskDefinitionArns()
    )(request.buildAwsValue()).map(item => item: String).provideEnvironment(r)
    def listTaskDefinitionsPaginated(
        request: ListTaskDefinitionsRequest
    ): IO[AwsError, zio.aws.ecs.model.ListTaskDefinitionsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest,
        ListTaskDefinitionsResponse
      ]("listTaskDefinitions", api.listTaskDefinitions)(request.buildAwsValue())
        .map(zio.aws.ecs.model.ListTaskDefinitionsResponse.wrap)
        .provideEnvironment(r)
    def deleteCapacityProvider(
        request: DeleteCapacityProviderRequest
    ): IO[AwsError, zio.aws.ecs.model.DeleteCapacityProviderResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest,
        DeleteCapacityProviderResponse
      ]("deleteCapacityProvider", api.deleteCapacityProvider)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.DeleteCapacityProviderResponse.wrap)
        .provideEnvironment(r)
    def deregisterTaskDefinition(request: DeregisterTaskDefinitionRequest): IO[
      AwsError,
      zio.aws.ecs.model.DeregisterTaskDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.DeregisterTaskDefinitionRequest,
      DeregisterTaskDefinitionResponse
    ]("deregisterTaskDefinition", api.deregisterTaskDefinition)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.DeregisterTaskDefinitionResponse.wrap)
      .provideEnvironment(r)
    def updateClusterSettings(
        request: UpdateClusterSettingsRequest
    ): IO[AwsError, zio.aws.ecs.model.UpdateClusterSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsRequest,
        UpdateClusterSettingsResponse
      ]("updateClusterSettings", api.updateClusterSettings)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.UpdateClusterSettingsResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.ecs.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.ecs.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def updateContainerInstancesState(
        request: UpdateContainerInstancesStateRequest
    ): IO[
      AwsError,
      zio.aws.ecs.model.UpdateContainerInstancesStateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.ecs.model.UpdateContainerInstancesStateRequest,
      UpdateContainerInstancesStateResponse
    ]("updateContainerInstancesState", api.updateContainerInstancesState)(
      request.buildAwsValue()
    ).map(zio.aws.ecs.model.UpdateContainerInstancesStateResponse.wrap)
      .provideEnvironment(r)
    def listClusters(
        request: ListClustersRequest
    ): ZStream[Any, AwsError, String] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.ecs.model.ListClustersRequest,
      java.lang.String,
      ListClustersPublisher
    ]("listClusters", api.listClustersPaginator, _.clusterArns())(
      request.buildAwsValue()
    ).map(item => item: String).provideEnvironment(r)
    def listClustersPaginated(
        request: ListClustersRequest
    ): IO[AwsError, zio.aws.ecs.model.ListClustersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ListClustersRequest,
        ListClustersResponse
      ]("listClusters", api.listClusters)(request.buildAwsValue())
        .map(zio.aws.ecs.model.ListClustersResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.ecs.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.ecs.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateTaskSet(
        request: UpdateTaskSetRequest
    ): IO[AwsError, zio.aws.ecs.model.UpdateTaskSetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.UpdateTaskSetRequest,
        UpdateTaskSetResponse
      ]("updateTaskSet", api.updateTaskSet)(request.buildAwsValue())
        .map(zio.aws.ecs.model.UpdateTaskSetResponse.wrap)
        .provideEnvironment(r)
    def listAccountSettings(
        request: ListAccountSettingsRequest
    ): ZStream[Any, AwsError, zio.aws.ecs.model.Setting.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest,
        Setting,
        ListAccountSettingsPublisher
      ]("listAccountSettings", api.listAccountSettingsPaginator, _.settings())(
        request.buildAwsValue()
      ).map(item => zio.aws.ecs.model.Setting.wrap(item)).provideEnvironment(r)
    def listAccountSettingsPaginated(
        request: ListAccountSettingsRequest
    ): IO[AwsError, zio.aws.ecs.model.ListAccountSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest,
        ListAccountSettingsResponse
      ]("listAccountSettings", api.listAccountSettings)(request.buildAwsValue())
        .map(zio.aws.ecs.model.ListAccountSettingsResponse.wrap)
        .provideEnvironment(r)
    def listTasks(request: ListTasksRequest): ZStream[Any, AwsError, String] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.ecs.model.ListTasksRequest,
        java.lang.String,
        ListTasksPublisher
      ]("listTasks", api.listTasksPaginator, _.taskArns())(
        request.buildAwsValue()
      ).map(item => item: String).provideEnvironment(r)
    def listTasksPaginated(
        request: ListTasksRequest
    ): IO[AwsError, zio.aws.ecs.model.ListTasksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ListTasksRequest,
        ListTasksResponse
      ]("listTasks", api.listTasks)(request.buildAwsValue())
        .map(zio.aws.ecs.model.ListTasksResponse.wrap)
        .provideEnvironment(r)
    def deleteAccountSetting(
        request: DeleteAccountSettingRequest
    ): IO[AwsError, zio.aws.ecs.model.DeleteAccountSettingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DeleteAccountSettingRequest,
        DeleteAccountSettingResponse
      ]("deleteAccountSetting", api.deleteAccountSetting)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.DeleteAccountSettingResponse.wrap)
        .provideEnvironment(r)
    def updateContainerAgent(
        request: UpdateContainerAgentRequest
    ): IO[AwsError, zio.aws.ecs.model.UpdateContainerAgentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.UpdateContainerAgentRequest,
        UpdateContainerAgentResponse
      ]("updateContainerAgent", api.updateContainerAgent)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.UpdateContainerAgentResponse.wrap)
        .provideEnvironment(r)
    def updateService(
        request: UpdateServiceRequest
    ): IO[AwsError, zio.aws.ecs.model.UpdateServiceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.UpdateServiceRequest,
        UpdateServiceResponse
      ]("updateService", api.updateService)(request.buildAwsValue())
        .map(zio.aws.ecs.model.UpdateServiceResponse.wrap)
        .provideEnvironment(r)
    def stopTask(
        request: StopTaskRequest
    ): IO[AwsError, zio.aws.ecs.model.StopTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.StopTaskRequest,
        StopTaskResponse
      ]("stopTask", api.stopTask)(request.buildAwsValue())
        .map(zio.aws.ecs.model.StopTaskResponse.wrap)
        .provideEnvironment(r)
    def updateCapacityProvider(
        request: UpdateCapacityProviderRequest
    ): IO[AwsError, zio.aws.ecs.model.UpdateCapacityProviderResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.UpdateCapacityProviderRequest,
        UpdateCapacityProviderResponse
      ]("updateCapacityProvider", api.updateCapacityProvider)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.UpdateCapacityProviderResponse.wrap)
        .provideEnvironment(r)
    def putAccountSetting(
        request: PutAccountSettingRequest
    ): IO[AwsError, zio.aws.ecs.model.PutAccountSettingResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest,
        PutAccountSettingResponse
      ]("putAccountSetting", api.putAccountSetting)(request.buildAwsValue())
        .map(zio.aws.ecs.model.PutAccountSettingResponse.wrap)
        .provideEnvironment(r)
    def createCapacityProvider(
        request: CreateCapacityProviderRequest
    ): IO[AwsError, zio.aws.ecs.model.CreateCapacityProviderResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.CreateCapacityProviderRequest,
        CreateCapacityProviderResponse
      ]("createCapacityProvider", api.createCapacityProvider)(
        request.buildAwsValue()
      ).map(zio.aws.ecs.model.CreateCapacityProviderResponse.wrap)
        .provideEnvironment(r)
    def listAttributes(
        request: ListAttributesRequest
    ): ZStream[Any, AwsError, zio.aws.ecs.model.Attribute.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.ecs.model.ListAttributesRequest,
        Attribute,
        ListAttributesPublisher
      ]("listAttributes", api.listAttributesPaginator, _.attributes())(
        request.buildAwsValue()
      ).map(item => zio.aws.ecs.model.Attribute.wrap(item))
        .provideEnvironment(r)
    def listAttributesPaginated(
        request: ListAttributesRequest
    ): IO[AwsError, zio.aws.ecs.model.ListAttributesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.ListAttributesRequest,
        ListAttributesResponse
      ]("listAttributes", api.listAttributes)(request.buildAwsValue())
        .map(zio.aws.ecs.model.ListAttributesResponse.wrap)
        .provideEnvironment(r)
    def describeServices(
        request: DescribeServicesRequest
    ): IO[AwsError, zio.aws.ecs.model.DescribeServicesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.ecs.model.DescribeServicesRequest,
        DescribeServicesResponse
      ]("describeServices", api.describeServices)(request.buildAwsValue())
        .map(zio.aws.ecs.model.DescribeServicesResponse.wrap)
        .provideEnvironment(r)
  }
  def registerTaskDefinition(request: RegisterTaskDefinitionRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.RegisterTaskDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerTaskDefinition(request))
  def submitContainerStateChange(
      request: SubmitContainerStateChangeRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.SubmitContainerStateChangeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.submitContainerStateChange(request))
  def submitAttachmentStateChanges(
      request: SubmitAttachmentStateChangesRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.submitAttachmentStateChanges(request))
  def describeTaskDefinition(request: DescribeTaskDefinitionRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DescribeTaskDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTaskDefinition(request))
  def describeClusters(request: DescribeClustersRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DescribeClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClusters(request))
  def putAccountSettingDefault(request: PutAccountSettingDefaultRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.PutAccountSettingDefaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountSettingDefault(request))
  def putAttributes(request: PutAttributesRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.PutAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAttributes(request))
  def listTaskDefinitionFamilies(
      request: ListTaskDefinitionFamiliesRequest
  ): ZStream[zio.aws.ecs.Ecs, AwsError, String] =
    ZStream.serviceWithStream(_.listTaskDefinitionFamilies(request))
  def listTaskDefinitionFamiliesPaginated(
      request: ListTaskDefinitionFamiliesRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTaskDefinitionFamiliesPaginated(request))
  def createService(request: CreateServiceRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.CreateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createService(request))
  def createTaskSet(request: CreateTaskSetRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.CreateTaskSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTaskSet(request))
  def startTask(request: StartTaskRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.StartTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTask(request))
  def deleteTaskSet(request: DeleteTaskSetRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DeleteTaskSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTaskSet(request))
  def deregisterContainerInstance(
      request: DeregisterContainerInstanceRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DeregisterContainerInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterContainerInstance(request))
  def discoverPollEndpoint(request: DiscoverPollEndpointRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DiscoverPollEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.discoverPollEndpoint(request))
  def registerContainerInstance(
      request: RegisterContainerInstanceRequest
  ): ZIO[zio.aws.ecs.Ecs, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.registerContainerInstance(request))
  def describeContainerInstances(
      request: DescribeContainerInstancesRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DescribeContainerInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeContainerInstances(request))
  def deleteAttributes(request: DeleteAttributesRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DeleteAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAttributes(request))
  def deleteService(request: DeleteServiceRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DeleteServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteService(request))
  def putClusterCapacityProviders(
      request: PutClusterCapacityProvidersRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.PutClusterCapacityProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putClusterCapacityProviders(request))
  def listServices(
      request: ListServicesRequest
  ): ZStream[zio.aws.ecs.Ecs, AwsError, String] =
    ZStream.serviceWithStream(_.listServices(request))
  def listServicesPaginated(request: ListServicesRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServicesPaginated(request))
  def createCluster(request: CreateClusterRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.CreateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCluster(request))
  def deleteCluster(request: DeleteClusterRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DeleteClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCluster(request))
  def describeTaskSets(request: DescribeTaskSetsRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DescribeTaskSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTaskSets(request))
  def updateCluster(request: UpdateClusterRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UpdateClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCluster(request))
  def executeCommand(request: ExecuteCommandRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.executeCommand(request))
  def runTask(request: RunTaskRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.RunTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.runTask(request))
  def listContainerInstances(
      request: ListContainerInstancesRequest
  ): ZStream[zio.aws.ecs.Ecs, AwsError, String] =
    ZStream.serviceWithStream(_.listContainerInstances(request))
  def listContainerInstancesPaginated(
      request: ListContainerInstancesRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListContainerInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listContainerInstancesPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def submitTaskStateChange(request: SubmitTaskStateChangeRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.SubmitTaskStateChangeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.submitTaskStateChange(request))
  def updateServicePrimaryTaskSet(
      request: UpdateServicePrimaryTaskSetRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateServicePrimaryTaskSet(request))
  def describeTasks(request: DescribeTasksRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DescribeTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTasks(request))
  def describeCapacityProviders(request: DescribeCapacityProvidersRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCapacityProviders(request))
  def listTaskDefinitions(
      request: ListTaskDefinitionsRequest
  ): ZStream[zio.aws.ecs.Ecs, AwsError, String] =
    ZStream.serviceWithStream(_.listTaskDefinitions(request))
  def listTaskDefinitionsPaginated(request: ListTaskDefinitionsRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListTaskDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTaskDefinitionsPaginated(request))
  def deleteCapacityProvider(request: DeleteCapacityProviderRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DeleteCapacityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCapacityProvider(request))
  def deregisterTaskDefinition(request: DeregisterTaskDefinitionRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DeregisterTaskDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterTaskDefinition(request))
  def updateClusterSettings(request: UpdateClusterSettingsRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UpdateClusterSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateClusterSettings(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def updateContainerInstancesState(
      request: UpdateContainerInstancesStateRequest
  ): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UpdateContainerInstancesStateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContainerInstancesState(request))
  def listClusters(
      request: ListClustersRequest
  ): ZStream[zio.aws.ecs.Ecs, AwsError, String] =
    ZStream.serviceWithStream(_.listClusters(request))
  def listClustersPaginated(request: ListClustersRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listClustersPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateTaskSet(request: UpdateTaskSetRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UpdateTaskSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTaskSet(request))
  def listAccountSettings(
      request: ListAccountSettingsRequest
  ): ZStream[zio.aws.ecs.Ecs, AwsError, zio.aws.ecs.model.Setting.ReadOnly] =
    ZStream.serviceWithStream(_.listAccountSettings(request))
  def listAccountSettingsPaginated(request: ListAccountSettingsRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListAccountSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccountSettingsPaginated(request))
  def listTasks(
      request: ListTasksRequest
  ): ZStream[zio.aws.ecs.Ecs, AwsError, String] =
    ZStream.serviceWithStream(_.listTasks(request))
  def listTasksPaginated(request: ListTasksRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTasksPaginated(request))
  def deleteAccountSetting(request: DeleteAccountSettingRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DeleteAccountSettingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccountSetting(request))
  def updateContainerAgent(request: UpdateContainerAgentRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UpdateContainerAgentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateContainerAgent(request))
  def updateService(request: UpdateServiceRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UpdateServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateService(request))
  def stopTask(request: StopTaskRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.StopTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopTask(request))
  def updateCapacityProvider(request: UpdateCapacityProviderRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.UpdateCapacityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateCapacityProvider(request))
  def putAccountSetting(request: PutAccountSettingRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.PutAccountSettingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountSetting(request))
  def createCapacityProvider(request: CreateCapacityProviderRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.CreateCapacityProviderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCapacityProvider(request))
  def listAttributes(
      request: ListAttributesRequest
  ): ZStream[zio.aws.ecs.Ecs, AwsError, zio.aws.ecs.model.Attribute.ReadOnly] =
    ZStream.serviceWithStream(_.listAttributes(request))
  def listAttributesPaginated(request: ListAttributesRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.ListAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttributesPaginated(request))
  def describeServices(request: DescribeServicesRequest): ZIO[
    zio.aws.ecs.Ecs,
    AwsError,
    zio.aws.ecs.model.DescribeServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeServices(request))
}
