package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Attachment(
    id: Option[String] = None,
    `type`: Option[String] = None,
    status: Option[String] = None,
    details: Option[Iterable[zio.aws.ecs.model.KeyValuePair]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Attachment = {
    import Attachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Attachment
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        details.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.details)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Attachment.ReadOnly =
    zio.aws.ecs.model.Attachment.wrap(buildAwsValue())
}
object Attachment {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Attachment] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Attachment = zio.aws.ecs.model.Attachment(
      id.map(value => value),
      `type`.map(value => value),
      status.map(value => value),
      details.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Option[String]
    def `type`: Option[String]
    def status: Option[String]
    def details: Option[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getDetails
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("details", details)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Attachment
  ) extends zio.aws.ecs.model.Attachment.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val details
        : Option[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.details())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.KeyValuePair.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Attachment
  ): zio.aws.ecs.model.Attachment.ReadOnly = new Wrapper(impl)
}
