package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait CapacityProviderStatus {
  def unwrap: software.amazon.awssdk.services.ecs.model.CapacityProviderStatus
}
object CapacityProviderStatus {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.CapacityProviderStatus
  ): zio.aws.ecs.model.CapacityProviderStatus = value match {
    case software.amazon.awssdk.services.ecs.model.CapacityProviderStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.CapacityProviderStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.ecs.model.CapacityProviderStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.CapacityProviderStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.CapacityProviderStatus =
      software.amazon.awssdk.services.ecs.model.CapacityProviderStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.ecs.model.CapacityProviderStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.CapacityProviderStatus =
      software.amazon.awssdk.services.ecs.model.CapacityProviderStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.ecs.model.CapacityProviderStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.CapacityProviderStatus =
      software.amazon.awssdk.services.ecs.model.CapacityProviderStatus.INACTIVE
  }
}
