package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait Compatibility {
  def unwrap: software.amazon.awssdk.services.ecs.model.Compatibility
}
object Compatibility {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.Compatibility
  ): zio.aws.ecs.model.Compatibility = value match {
    case software.amazon.awssdk.services.ecs.model.Compatibility.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.Compatibility.EC2 =>
      val r = EC2
      r
    case software.amazon.awssdk.services.ecs.model.Compatibility.FARGATE =>
      val r = FARGATE
      r
    case software.amazon.awssdk.services.ecs.model.Compatibility.EXTERNAL =>
      val r = EXTERNAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.Compatibility {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.Compatibility =
      software.amazon.awssdk.services.ecs.model.Compatibility.UNKNOWN_TO_SDK_VERSION
  }
  case object EC2 extends zio.aws.ecs.model.Compatibility {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.Compatibility =
      software.amazon.awssdk.services.ecs.model.Compatibility.EC2
  }
  case object FARGATE extends zio.aws.ecs.model.Compatibility {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.Compatibility =
      software.amazon.awssdk.services.ecs.model.Compatibility.FARGATE
  }
  case object EXTERNAL extends zio.aws.ecs.model.Compatibility {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.Compatibility =
      software.amazon.awssdk.services.ecs.model.Compatibility.EXTERNAL
  }
}
