package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerCondition {
  def unwrap: software.amazon.awssdk.services.ecs.model.ContainerCondition
}
object ContainerCondition {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ContainerCondition
  ): zio.aws.ecs.model.ContainerCondition = value match {
    case software.amazon.awssdk.services.ecs.model.ContainerCondition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ContainerCondition.START =>
      val r = START
      r
    case software.amazon.awssdk.services.ecs.model.ContainerCondition.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.ecs.model.ContainerCondition.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.ecs.model.ContainerCondition.HEALTHY =>
      val r = HEALTHY
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.ContainerCondition {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerCondition =
      software.amazon.awssdk.services.ecs.model.ContainerCondition.UNKNOWN_TO_SDK_VERSION
  }
  case object START extends zio.aws.ecs.model.ContainerCondition {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerCondition =
      software.amazon.awssdk.services.ecs.model.ContainerCondition.START
  }
  case object COMPLETE extends zio.aws.ecs.model.ContainerCondition {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerCondition =
      software.amazon.awssdk.services.ecs.model.ContainerCondition.COMPLETE
  }
  case object SUCCESS extends zio.aws.ecs.model.ContainerCondition {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerCondition =
      software.amazon.awssdk.services.ecs.model.ContainerCondition.SUCCESS
  }
  case object HEALTHY extends zio.aws.ecs.model.ContainerCondition {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerCondition =
      software.amazon.awssdk.services.ecs.model.ContainerCondition.HEALTHY
  }
}
