package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ContainerDependency(
    containerName: String,
    condition: zio.aws.ecs.model.ContainerCondition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerDependency = {
    import ContainerDependency.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerDependency
      .builder()
      .containerName(containerName: java.lang.String)
      .condition(condition.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerDependency.ReadOnly =
    zio.aws.ecs.model.ContainerDependency.wrap(buildAwsValue())
}
object ContainerDependency {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerDependency
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerDependency =
      zio.aws.ecs.model.ContainerDependency(containerName, condition)
    def containerName: String
    def condition: zio.aws.ecs.model.ContainerCondition
    def getContainerName: ZIO[Any, Nothing, String] = ZIO.succeed(containerName)
    def getCondition: ZIO[Any, Nothing, zio.aws.ecs.model.ContainerCondition] =
      ZIO.succeed(condition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerDependency
  ) extends zio.aws.ecs.model.ContainerDependency.ReadOnly {
    override val containerName: String = impl.containerName(): String
    override val condition: zio.aws.ecs.model.ContainerCondition =
      zio.aws.ecs.model.ContainerCondition.wrap(impl.condition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerDependency
  ): zio.aws.ecs.model.ContainerDependency.ReadOnly = new Wrapper(impl)
}
