package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.{Timestamp, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ContainerInstance(
    containerInstanceArn: Option[String] = None,
    ec2InstanceId: Option[String] = None,
    capacityProviderName: Option[String] = None,
    version: Option[Long] = None,
    versionInfo: Option[zio.aws.ecs.model.VersionInfo] = None,
    remainingResources: Option[Iterable[zio.aws.ecs.model.Resource]] = None,
    registeredResources: Option[Iterable[zio.aws.ecs.model.Resource]] = None,
    status: Option[String] = None,
    statusReason: Option[String] = None,
    agentConnected: Option[Boolean] = None,
    runningTasksCount: Option[Integer] = None,
    pendingTasksCount: Option[Integer] = None,
    agentUpdateStatus: Option[zio.aws.ecs.model.AgentUpdateStatus] = None,
    attributes: Option[Iterable[zio.aws.ecs.model.Attribute]] = None,
    registeredAt: Option[Timestamp] = None,
    attachments: Option[Iterable[zio.aws.ecs.model.Attachment]] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None,
    healthStatus: Option[zio.aws.ecs.model.ContainerInstanceHealthStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerInstance = {
    import ContainerInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerInstance
      .builder()
      .optionallyWith(
        containerInstanceArn.map(value => value: java.lang.String)
      )(_.containerInstanceArn)
      .optionallyWith(ec2InstanceId.map(value => value: java.lang.String))(
        _.ec2InstanceId
      )
      .optionallyWith(
        capacityProviderName.map(value => value: java.lang.String)
      )(_.capacityProviderName)
      .optionallyWith(version.map(value => value: java.lang.Long))(_.version)
      .optionallyWith(versionInfo.map(value => value.buildAwsValue()))(
        _.versionInfo
      )
      .optionallyWith(
        remainingResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.remainingResources)
      .optionallyWith(
        registeredResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.registeredResources)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(agentConnected.map(value => value: java.lang.Boolean))(
        _.agentConnected
      )
      .optionallyWith(
        runningTasksCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.runningTasksCount)
      .optionallyWith(
        pendingTasksCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.pendingTasksCount)
      .optionallyWith(agentUpdateStatus.map(value => value.unwrap))(
        _.agentUpdateStatus
      )
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        registeredAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.registeredAt)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(healthStatus.map(value => value.buildAwsValue()))(
        _.healthStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerInstance.ReadOnly =
    zio.aws.ecs.model.ContainerInstance.wrap(buildAwsValue())
}
object ContainerInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerInstance =
      zio.aws.ecs.model.ContainerInstance(
        containerInstanceArn.map(value => value),
        ec2InstanceId.map(value => value),
        capacityProviderName.map(value => value),
        version.map(value => value),
        versionInfo.map(value => value.asEditable),
        remainingResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        registeredResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        statusReason.map(value => value),
        agentConnected.map(value => value),
        runningTasksCount.map(value => value),
        pendingTasksCount.map(value => value),
        agentUpdateStatus.map(value => value),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        registeredAt.map(value => value),
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        healthStatus.map(value => value.asEditable)
      )
    def containerInstanceArn: Option[String]
    def ec2InstanceId: Option[String]
    def capacityProviderName: Option[String]
    def version: Option[Long]
    def versionInfo: Option[zio.aws.ecs.model.VersionInfo.ReadOnly]
    def remainingResources: Option[List[zio.aws.ecs.model.Resource.ReadOnly]]
    def registeredResources: Option[List[zio.aws.ecs.model.Resource.ReadOnly]]
    def status: Option[String]
    def statusReason: Option[String]
    def agentConnected: Option[Boolean]
    def runningTasksCount: Option[Integer]
    def pendingTasksCount: Option[Integer]
    def agentUpdateStatus: Option[zio.aws.ecs.model.AgentUpdateStatus]
    def attributes: Option[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def registeredAt: Option[Timestamp]
    def attachments: Option[List[zio.aws.ecs.model.Attachment.ReadOnly]]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def healthStatus
        : Option[zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly]
    def getContainerInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstanceArn", containerInstanceArn)
    def getEc2InstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getCapacityProviderName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityProviderName", capacityProviderName)
    def getVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("version", version)
    def getVersionInfo
        : ZIO[Any, AwsError, zio.aws.ecs.model.VersionInfo.ReadOnly] =
      AwsError.unwrapOptionField("versionInfo", versionInfo)
    def getRemainingResources
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("remainingResources", remainingResources)
    def getRegisteredResources
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("registeredResources", registeredResources)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getAgentConnected: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("agentConnected", agentConnected)
    def getRunningTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningTasksCount", runningTasksCount)
    def getPendingTasksCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingTasksCount", pendingTasksCount)
    def getAgentUpdateStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.AgentUpdateStatus] =
      AwsError.unwrapOptionField("agentUpdateStatus", agentUpdateStatus)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getRegisteredAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("registeredAt", registeredAt)
    def getAttachments
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attachment.ReadOnly]] =
      AwsError.unwrapOptionField("attachments", attachments)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getHealthStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly
    ] = AwsError.unwrapOptionField("healthStatus", healthStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerInstance
  ) extends zio.aws.ecs.model.ContainerInstance.ReadOnly {
    override val containerInstanceArn: Option[String] =
      scala.Option(impl.containerInstanceArn()).map(value => value: String)
    override val ec2InstanceId: Option[String] =
      scala.Option(impl.ec2InstanceId()).map(value => value: String)
    override val capacityProviderName: Option[String] =
      scala.Option(impl.capacityProviderName()).map(value => value: String)
    override val version: Option[Long] =
      scala.Option(impl.version()).map(value => value: Long)
    override val versionInfo: Option[zio.aws.ecs.model.VersionInfo.ReadOnly] =
      scala
        .Option(impl.versionInfo())
        .map(value => zio.aws.ecs.model.VersionInfo.wrap(value))
    override val remainingResources
        : Option[List[zio.aws.ecs.model.Resource.ReadOnly]] = scala
      .Option(impl.remainingResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Resource.wrap(item)
        }.toList
      )
    override val registeredResources
        : Option[List[zio.aws.ecs.model.Resource.ReadOnly]] = scala
      .Option(impl.registeredResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Resource.wrap(item)
        }.toList
      )
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val statusReason: Option[String] =
      scala.Option(impl.statusReason()).map(value => value: String)
    override val agentConnected: Option[Boolean] =
      scala.Option(impl.agentConnected()).map(value => value: Boolean)
    override val runningTasksCount: Option[Integer] = scala
      .Option(impl.runningTasksCount())
      .map(value => zio.aws.ecs.model.primitives.Integer(value))
    override val pendingTasksCount: Option[Integer] = scala
      .Option(impl.pendingTasksCount())
      .map(value => zio.aws.ecs.model.primitives.Integer(value))
    override val agentUpdateStatus
        : Option[zio.aws.ecs.model.AgentUpdateStatus] = scala
      .Option(impl.agentUpdateStatus())
      .map(value => zio.aws.ecs.model.AgentUpdateStatus.wrap(value))
    override val attributes
        : Option[List[zio.aws.ecs.model.Attribute.ReadOnly]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Attribute.wrap(item)
        }.toList
      )
    override val registeredAt: Option[Timestamp] = scala
      .Option(impl.registeredAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val attachments
        : Option[List[zio.aws.ecs.model.Attachment.ReadOnly]] = scala
      .Option(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Attachment.wrap(item)
        }.toList
      )
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
    override val healthStatus
        : Option[zio.aws.ecs.model.ContainerInstanceHealthStatus.ReadOnly] =
      scala
        .Option(impl.healthStatus())
        .map(value =>
          zio.aws.ecs.model.ContainerInstanceHealthStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerInstance
  ): zio.aws.ecs.model.ContainerInstance.ReadOnly = new Wrapper(impl)
}
