package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateClusterResponse(
    cluster: Option[zio.aws.ecs.model.Cluster] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateClusterResponse = {
    import CreateClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateClusterResponse.ReadOnly =
    zio.aws.ecs.model.CreateClusterResponse.wrap(buildAwsValue())
}
object CreateClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateClusterResponse = zio.aws.ecs.model
      .CreateClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Option[zio.aws.ecs.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.ecs.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateClusterResponse
  ) extends zio.aws.ecs.model.CreateClusterResponse.ReadOnly {
    override val cluster: Option[zio.aws.ecs.model.Cluster.ReadOnly] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.ecs.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateClusterResponse
  ): zio.aws.ecs.model.CreateClusterResponse.ReadOnly = new Wrapper(impl)
}
