package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCapacityProviderRequest(capacityProvider: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest = {
    import DeleteCapacityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest
      .builder()
      .capacityProvider(capacityProvider: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteCapacityProviderRequest.ReadOnly =
    zio.aws.ecs.model.DeleteCapacityProviderRequest.wrap(buildAwsValue())
}
object DeleteCapacityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteCapacityProviderRequest =
      zio.aws.ecs.model.DeleteCapacityProviderRequest(capacityProvider)
    def capacityProvider: String
    def getCapacityProvider: ZIO[Any, Nothing, String] =
      ZIO.succeed(capacityProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest
  ) extends zio.aws.ecs.model.DeleteCapacityProviderRequest.ReadOnly {
    override val capacityProvider: String = impl.capacityProvider(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteCapacityProviderRequest
  ): zio.aws.ecs.model.DeleteCapacityProviderRequest.ReadOnly = new Wrapper(
    impl
  )
}
