package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteTaskSetRequest(
    cluster: String,
    service: String,
    taskSet: String,
    force: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest = {
    import DeleteTaskSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .service(service: java.lang.String)
      .taskSet(taskSet: java.lang.String)
      .optionallyWith(
        force.map(value => BoxedBoolean.unwrap(value): java.lang.Boolean)
      )(_.force)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DeleteTaskSetRequest.ReadOnly =
    zio.aws.ecs.model.DeleteTaskSetRequest.wrap(buildAwsValue())
}
object DeleteTaskSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeleteTaskSetRequest =
      zio.aws.ecs.model.DeleteTaskSetRequest(
        cluster,
        service,
        taskSet,
        force.map(value => value)
      )
    def cluster: String
    def service: String
    def taskSet: String
    def force: Option[BoxedBoolean]
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getTaskSet: ZIO[Any, Nothing, String] = ZIO.succeed(taskSet)
    def getForce: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest
  ) extends zio.aws.ecs.model.DeleteTaskSetRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val service: String = impl.service(): String
    override val taskSet: String = impl.taskSet(): String
    override val force: Option[BoxedBoolean] = scala
      .Option(impl.force())
      .map(value => zio.aws.ecs.model.primitives.BoxedBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeleteTaskSetRequest
  ): zio.aws.ecs.model.DeleteTaskSetRequest.ReadOnly = new Wrapper(impl)
}
