package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentRolloutState {
  def unwrap: software.amazon.awssdk.services.ecs.model.DeploymentRolloutState
}
object DeploymentRolloutState {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.DeploymentRolloutState
  ): zio.aws.ecs.model.DeploymentRolloutState = value match {
    case software.amazon.awssdk.services.ecs.model.DeploymentRolloutState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.DeploymentRolloutState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.ecs.model.DeploymentRolloutState.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.ecs.model.DeploymentRolloutState.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.DeploymentRolloutState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeploymentRolloutState =
      software.amazon.awssdk.services.ecs.model.DeploymentRolloutState.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED extends zio.aws.ecs.model.DeploymentRolloutState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeploymentRolloutState =
      software.amazon.awssdk.services.ecs.model.DeploymentRolloutState.COMPLETED
  }
  case object FAILED extends zio.aws.ecs.model.DeploymentRolloutState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeploymentRolloutState =
      software.amazon.awssdk.services.ecs.model.DeploymentRolloutState.FAILED
  }
  case object IN_PROGRESS extends zio.aws.ecs.model.DeploymentRolloutState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeploymentRolloutState =
      software.amazon.awssdk.services.ecs.model.DeploymentRolloutState.IN_PROGRESS
  }
}
