package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeClustersResponse(
    clusters: Option[Iterable[zio.aws.ecs.model.Cluster]] = None,
    failures: Option[Iterable[zio.aws.ecs.model.Failure]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeClustersResponse = {
    import DescribeClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeClustersResponse
      .builder()
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeClustersResponse.ReadOnly =
    zio.aws.ecs.model.DescribeClustersResponse.wrap(buildAwsValue())
}
object DescribeClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeClustersResponse =
      zio.aws.ecs.model.DescribeClustersResponse(
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusters: Option[List[zio.aws.ecs.model.Cluster.ReadOnly]]
    def failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getClusters
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeClustersResponse
  ) extends zio.aws.ecs.model.DescribeClustersResponse.ReadOnly {
    override val clusters: Option[List[zio.aws.ecs.model.Cluster.ReadOnly]] =
      scala
        .Option(impl.clusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Cluster.wrap(item)
          }.toList
        )
    override val failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      scala
        .Option(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeClustersResponse
  ): zio.aws.ecs.model.DescribeClustersResponse.ReadOnly = new Wrapper(impl)
}
