package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeTasksRequest(
    cluster: Option[String] = None,
    tasks: Iterable[String],
    include: Option[Iterable[zio.aws.ecs.model.TaskField]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeTasksRequest = {
    import DescribeTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeTasksRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .tasks(tasks.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeTasksRequest.ReadOnly =
    zio.aws.ecs.model.DescribeTasksRequest.wrap(buildAwsValue())
}
object DescribeTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeTasksRequest =
      zio.aws.ecs.model.DescribeTasksRequest(
        cluster.map(value => value),
        tasks,
        include.map(value => value)
      )
    def cluster: Option[String]
    def tasks: List[String]
    def include: Option[List[zio.aws.ecs.model.TaskField]]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTasks: ZIO[Any, Nothing, List[String]] = ZIO.succeed(tasks)
    def getInclude: ZIO[Any, AwsError, List[zio.aws.ecs.model.TaskField]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTasksRequest
  ) extends zio.aws.ecs.model.DescribeTasksRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val tasks: List[String] = impl
      .tasks()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val include: Option[List[zio.aws.ecs.model.TaskField]] = scala
      .Option(impl.include())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.TaskField.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeTasksRequest
  ): zio.aws.ecs.model.DescribeTasksRequest.ReadOnly = new Wrapper(impl)
}
