package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait EFSAuthorizationConfigIAM {
  def unwrap
      : software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM
}
object EFSAuthorizationConfigIAM {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM
  ): zio.aws.ecs.model.EFSAuthorizationConfigIAM = value match {
    case software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.EFSAuthorizationConfigIAM {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM =
      software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.ecs.model.EFSAuthorizationConfigIAM {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM =
      software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM.ENABLED
  }
  case object DISABLED extends zio.aws.ecs.model.EFSAuthorizationConfigIAM {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM =
      software.amazon.awssdk.services.ecs.model.EFSAuthorizationConfigIAM.DISABLED
  }
}
