package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait ExecuteCommandLogging {
  def unwrap: software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging
}
object ExecuteCommandLogging {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging
  ): zio.aws.ecs.model.ExecuteCommandLogging = value match {
    case software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging.OVERRIDE =>
      val r = OVERRIDE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.ExecuteCommandLogging {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging =
      software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.ecs.model.ExecuteCommandLogging {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging =
      software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging.NONE
  }
  case object DEFAULT extends zio.aws.ecs.model.ExecuteCommandLogging {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging =
      software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging.DEFAULT
  }
  case object OVERRIDE extends zio.aws.ecs.model.ExecuteCommandLogging {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging =
      software.amazon.awssdk.services.ecs.model.ExecuteCommandLogging.OVERRIDE
  }
}
