package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FSxWindowsFileServerVolumeConfiguration(
    fileSystemId: String,
    rootDirectory: String,
    authorizationConfig: zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerVolumeConfiguration = {
    import FSxWindowsFileServerVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerVolumeConfiguration
      .builder()
      .fileSystemId(fileSystemId: java.lang.String)
      .rootDirectory(rootDirectory: java.lang.String)
      .authorizationConfig(authorizationConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration.ReadOnly =
    zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration
      .wrap(buildAwsValue())
}
object FSxWindowsFileServerVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration =
      zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration(
        fileSystemId,
        rootDirectory,
        authorizationConfig.asEditable
      )
    def fileSystemId: String
    def rootDirectory: String
    def authorizationConfig
        : zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig.ReadOnly
    def getFileSystemId: ZIO[Any, Nothing, String] = ZIO.succeed(fileSystemId)
    def getRootDirectory: ZIO[Any, Nothing, String] = ZIO.succeed(rootDirectory)
    def getAuthorizationConfig: ZIO[
      Any,
      Nothing,
      zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig.ReadOnly
    ] = ZIO.succeed(authorizationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerVolumeConfiguration
  ) extends zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration.ReadOnly {
    override val fileSystemId: String = impl.fileSystemId(): String
    override val rootDirectory: String = impl.rootDirectory(): String
    override val authorizationConfig
        : zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig.ReadOnly =
      zio.aws.ecs.model.FSxWindowsFileServerAuthorizationConfig
        .wrap(impl.authorizationConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.FSxWindowsFileServerVolumeConfiguration
  ): zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration.ReadOnly =
    new Wrapper(impl)
}
