package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceHealthCheckState {
  def unwrap: software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState
}
object InstanceHealthCheckState {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState
  ): zio.aws.ecs.model.InstanceHealthCheckState = value match {
    case software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.OK =>
      val r = OK
      r
    case software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.IMPAIRED =>
      val r = IMPAIRED
      r
    case software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.INSUFFICIENT_DATA =>
      val r = INSUFFICIENT_DATA
      r
    case software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.INITIALIZING =>
      val r = INITIALIZING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.InstanceHealthCheckState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState =
      software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.UNKNOWN_TO_SDK_VERSION
  }
  case object OK extends zio.aws.ecs.model.InstanceHealthCheckState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState =
      software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.OK
  }
  case object IMPAIRED extends zio.aws.ecs.model.InstanceHealthCheckState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState =
      software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.IMPAIRED
  }
  case object INSUFFICIENT_DATA
      extends zio.aws.ecs.model.InstanceHealthCheckState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState =
      software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.INSUFFICIENT_DATA
  }
  case object INITIALIZING extends zio.aws.ecs.model.InstanceHealthCheckState {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState =
      software.amazon.awssdk.services.ecs.model.InstanceHealthCheckState.INITIALIZING
  }
}
