package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTaskDefinitionFamiliesRequest(
    familyPrefix: Option[String] = None,
    status: Option[zio.aws.ecs.model.TaskDefinitionFamilyStatus] = None,
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest = {
    import ListTaskDefinitionFamiliesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest
      .builder()
      .optionallyWith(familyPrefix.map(value => value: java.lang.String))(
        _.familyPrefix
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => BoxedInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest.ReadOnly =
    zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest.wrap(buildAwsValue())
}
object ListTaskDefinitionFamiliesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest =
      zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest(
        familyPrefix.map(value => value),
        status.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def familyPrefix: Option[String]
    def status: Option[zio.aws.ecs.model.TaskDefinitionFamilyStatus]
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def getFamilyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("familyPrefix", familyPrefix)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinitionFamilyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest
  ) extends zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest.ReadOnly {
    override val familyPrefix: Option[String] =
      scala.Option(impl.familyPrefix()).map(value => value: String)
    override val status: Option[zio.aws.ecs.model.TaskDefinitionFamilyStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ecs.model.TaskDefinitionFamilyStatus.wrap(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ecs.model.primitives.BoxedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesRequest
  ): zio.aws.ecs.model.ListTaskDefinitionFamiliesRequest.ReadOnly = new Wrapper(
    impl
  )
}
