package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LogConfiguration(
    logDriver: zio.aws.ecs.model.LogDriver,
    options: Option[Map[String, String]] = None,
    secretOptions: Option[Iterable[zio.aws.ecs.model.Secret]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.LogConfiguration = {
    import LogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.LogConfiguration
      .builder()
      .logDriver(logDriver.unwrap)
      .optionallyWith(
        options.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.options)
      .optionallyWith(
        secretOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secretOptions)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.LogConfiguration.ReadOnly =
    zio.aws.ecs.model.LogConfiguration.wrap(buildAwsValue())
}
object LogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.LogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.LogConfiguration =
      zio.aws.ecs.model.LogConfiguration(
        logDriver,
        options.map(value => value),
        secretOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def logDriver: zio.aws.ecs.model.LogDriver
    def options: Option[Map[String, String]]
    def secretOptions: Option[List[zio.aws.ecs.model.Secret.ReadOnly]]
    def getLogDriver: ZIO[Any, Nothing, zio.aws.ecs.model.LogDriver] =
      ZIO.succeed(logDriver)
    def getOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("options", options)
    def getSecretOptions
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Secret.ReadOnly]] =
      AwsError.unwrapOptionField("secretOptions", secretOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.LogConfiguration
  ) extends zio.aws.ecs.model.LogConfiguration.ReadOnly {
    override val logDriver: zio.aws.ecs.model.LogDriver =
      zio.aws.ecs.model.LogDriver.wrap(impl.logDriver())
    override val options: Option[Map[String, String]] = scala
      .Option(impl.options())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val secretOptions
        : Option[List[zio.aws.ecs.model.Secret.ReadOnly]] = scala
      .Option(impl.secretOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Secret.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.LogConfiguration
  ): zio.aws.ecs.model.LogConfiguration.ReadOnly = new Wrapper(impl)
}
