package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait ManagedAgentName {
  def unwrap: software.amazon.awssdk.services.ecs.model.ManagedAgentName
}
object ManagedAgentName {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ManagedAgentName
  ): zio.aws.ecs.model.ManagedAgentName = value match {
    case software.amazon.awssdk.services.ecs.model.ManagedAgentName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ManagedAgentName.EXECUTE_COMMAND_AGENT =>
      val r = ExecuteCommandAgent
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.ManagedAgentName {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ManagedAgentName =
      software.amazon.awssdk.services.ecs.model.ManagedAgentName.UNKNOWN_TO_SDK_VERSION
  }
  case object ExecuteCommandAgent extends zio.aws.ecs.model.ManagedAgentName {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ManagedAgentName =
      software.amazon.awssdk.services.ecs.model.ManagedAgentName.EXECUTE_COMMAND_AGENT
  }
}
