package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait ManagedScalingStatus {
  def unwrap: software.amazon.awssdk.services.ecs.model.ManagedScalingStatus
}
object ManagedScalingStatus {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ManagedScalingStatus
  ): zio.aws.ecs.model.ManagedScalingStatus = value match {
    case software.amazon.awssdk.services.ecs.model.ManagedScalingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ManagedScalingStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.ecs.model.ManagedScalingStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.ManagedScalingStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ManagedScalingStatus =
      software.amazon.awssdk.services.ecs.model.ManagedScalingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.ecs.model.ManagedScalingStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ManagedScalingStatus =
      software.amazon.awssdk.services.ecs.model.ManagedScalingStatus.ENABLED
  }
  case object DISABLED extends zio.aws.ecs.model.ManagedScalingStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ManagedScalingStatus =
      software.amazon.awssdk.services.ecs.model.ManagedScalingStatus.DISABLED
  }
}
