package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NetworkConfiguration(
    awsvpcConfiguration: Option[zio.aws.ecs.model.AwsVpcConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.NetworkConfiguration = {
    import NetworkConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.NetworkConfiguration
      .builder()
      .optionallyWith(awsvpcConfiguration.map(value => value.buildAwsValue()))(
        _.awsvpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.NetworkConfiguration.ReadOnly =
    zio.aws.ecs.model.NetworkConfiguration.wrap(buildAwsValue())
}
object NetworkConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.NetworkConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.NetworkConfiguration = zio.aws.ecs.model
      .NetworkConfiguration(awsvpcConfiguration.map(value => value.asEditable))
    def awsvpcConfiguration
        : Option[zio.aws.ecs.model.AwsVpcConfiguration.ReadOnly]
    def getAwsvpcConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.AwsVpcConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("awsvpcConfiguration", awsvpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.NetworkConfiguration
  ) extends zio.aws.ecs.model.NetworkConfiguration.ReadOnly {
    override val awsvpcConfiguration
        : Option[zio.aws.ecs.model.AwsVpcConfiguration.ReadOnly] = scala
      .Option(impl.awsvpcConfiguration())
      .map(value => zio.aws.ecs.model.AwsVpcConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.NetworkConfiguration
  ): zio.aws.ecs.model.NetworkConfiguration.ReadOnly = new Wrapper(impl)
}
