package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait OSFamily {
  def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily
}
object OSFamily {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.OSFamily
  ): zio.aws.ecs.model.OSFamily = value match {
    case software.amazon.awssdk.services.ecs.model.OSFamily.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2019_FULL =>
      val r = WINDOWS_SERVER_2019_FULL
      r
    case software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2019_CORE =>
      val r = WINDOWS_SERVER_2019_CORE
      r
    case software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2016_FULL =>
      val r = WINDOWS_SERVER_2016_FULL
      r
    case software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2004_CORE =>
      val r = WINDOWS_SERVER_2004_CORE
      r
    case software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2022_CORE =>
      val r = WINDOWS_SERVER_2022_CORE
      r
    case software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2022_FULL =>
      val r = WINDOWS_SERVER_2022_FULL
      r
    case software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_20_H2_CORE =>
      val r = WINDOWS_SERVER_20H2_CORE
      r
    case software.amazon.awssdk.services.ecs.model.OSFamily.LINUX =>
      val r = LINUX
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.UNKNOWN_TO_SDK_VERSION
  }
  case object WINDOWS_SERVER_2019_FULL extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2019_FULL
  }
  case object WINDOWS_SERVER_2019_CORE extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2019_CORE
  }
  case object WINDOWS_SERVER_2016_FULL extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2016_FULL
  }
  case object WINDOWS_SERVER_2004_CORE extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2004_CORE
  }
  case object WINDOWS_SERVER_2022_CORE extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2022_CORE
  }
  case object WINDOWS_SERVER_2022_FULL extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_2022_FULL
  }
  case object WINDOWS_SERVER_20H2_CORE extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.WINDOWS_SERVER_20_H2_CORE
  }
  case object LINUX extends zio.aws.ecs.model.OSFamily {
    override def unwrap: software.amazon.awssdk.services.ecs.model.OSFamily =
      software.amazon.awssdk.services.ecs.model.OSFamily.LINUX
  }
}
