package zio.aws.ecs.model
import scala.jdk.CollectionConverters.*
sealed trait PropagateTags {
  def unwrap: software.amazon.awssdk.services.ecs.model.PropagateTags
}
object PropagateTags {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.PropagateTags
  ): zio.aws.ecs.model.PropagateTags = value match {
    case software.amazon.awssdk.services.ecs.model.PropagateTags.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.PropagateTags.TASK_DEFINITION =>
      val r = TASK_DEFINITION
      r
    case software.amazon.awssdk.services.ecs.model.PropagateTags.SERVICE =>
      val r = SERVICE
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.PropagateTags {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PropagateTags =
      software.amazon.awssdk.services.ecs.model.PropagateTags.UNKNOWN_TO_SDK_VERSION
  }
  case object TASK_DEFINITION extends zio.aws.ecs.model.PropagateTags {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PropagateTags =
      software.amazon.awssdk.services.ecs.model.PropagateTags.TASK_DEFINITION
  }
  case object SERVICE extends zio.aws.ecs.model.PropagateTags {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PropagateTags =
      software.amazon.awssdk.services.ecs.model.PropagateTags.SERVICE
  }
}
