package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutAccountSettingDefaultResponse(
    setting: Option[zio.aws.ecs.model.Setting] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultResponse = {
    import PutAccountSettingDefaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultResponse
      .builder()
      .optionallyWith(setting.map(value => value.buildAwsValue()))(_.setting)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PutAccountSettingDefaultResponse.ReadOnly =
    zio.aws.ecs.model.PutAccountSettingDefaultResponse.wrap(buildAwsValue())
}
object PutAccountSettingDefaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PutAccountSettingDefaultResponse =
      zio.aws.ecs.model.PutAccountSettingDefaultResponse(
        setting.map(value => value.asEditable)
      )
    def setting: Option[zio.aws.ecs.model.Setting.ReadOnly]
    def getSetting: ZIO[Any, AwsError, zio.aws.ecs.model.Setting.ReadOnly] =
      AwsError.unwrapOptionField("setting", setting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultResponse
  ) extends zio.aws.ecs.model.PutAccountSettingDefaultResponse.ReadOnly {
    override val setting: Option[zio.aws.ecs.model.Setting.ReadOnly] = scala
      .Option(impl.setting())
      .map(value => zio.aws.ecs.model.Setting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PutAccountSettingDefaultResponse
  ): zio.aws.ecs.model.PutAccountSettingDefaultResponse.ReadOnly = new Wrapper(
    impl
  )
}
