package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutAccountSettingRequest(
    name: zio.aws.ecs.model.SettingName,
    value: String,
    principalArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest = {
    import PutAccountSettingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest
      .builder()
      .name(name.unwrap)
      .value(value: java.lang.String)
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PutAccountSettingRequest.ReadOnly =
    zio.aws.ecs.model.PutAccountSettingRequest.wrap(buildAwsValue())
}
object PutAccountSettingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PutAccountSettingRequest =
      zio.aws.ecs.model
        .PutAccountSettingRequest(name, value, principalArn.map(value => value))
    def name: zio.aws.ecs.model.SettingName
    def value: String
    def principalArn: Option[String]
    def getName: ZIO[Any, Nothing, zio.aws.ecs.model.SettingName] =
      ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
    def getPrincipalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest
  ) extends zio.aws.ecs.model.PutAccountSettingRequest.ReadOnly {
    override val name: zio.aws.ecs.model.SettingName =
      zio.aws.ecs.model.SettingName.wrap(impl.name())
    override val value: String = impl.value(): String
    override val principalArn: Option[String] =
      scala.Option(impl.principalArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PutAccountSettingRequest
  ): zio.aws.ecs.model.PutAccountSettingRequest.ReadOnly = new Wrapper(impl)
}
