package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResourceRequirement(
    value: String,
    `type`: zio.aws.ecs.model.ResourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ResourceRequirement = {
    import ResourceRequirement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ResourceRequirement
      .builder()
      .value(value: java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ResourceRequirement.ReadOnly =
    zio.aws.ecs.model.ResourceRequirement.wrap(buildAwsValue())
}
object ResourceRequirement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ResourceRequirement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ResourceRequirement =
      zio.aws.ecs.model.ResourceRequirement(value, `type`)
    def value: String
    def `type`: zio.aws.ecs.model.ResourceType
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
    def getType: ZIO[Any, Nothing, zio.aws.ecs.model.ResourceType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ResourceRequirement
  ) extends zio.aws.ecs.model.ResourceRequirement.ReadOnly {
    override val value: String = impl.value(): String
    override val `type`: zio.aws.ecs.model.ResourceType =
      zio.aws.ecs.model.ResourceType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ResourceRequirement
  ): zio.aws.ecs.model.ResourceRequirement.ReadOnly = new Wrapper(impl)
}
