package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ServiceEvent(
    id: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ServiceEvent = {
    import ServiceEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ServiceEvent
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ServiceEvent.ReadOnly =
    zio.aws.ecs.model.ServiceEvent.wrap(buildAwsValue())
}
object ServiceEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.ServiceEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ServiceEvent =
      zio.aws.ecs.model.ServiceEvent(
        id.map(value => value),
        createdAt.map(value => value),
        message.map(value => value)
      )
    def id: Option[String]
    def createdAt: Option[Timestamp]
    def message: Option[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ServiceEvent
  ) extends zio.aws.ecs.model.ServiceEvent.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ServiceEvent
  ): zio.aws.ecs.model.ServiceEvent.ReadOnly = new Wrapper(impl)
}
